/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.parser.standardization;

import com.google.protobuf.AbstractMessageLite;
import java.io.IOException;
import java.util.List;
import org.apache.skywalking.apm.commons.datacarrier.DataCarrier;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IConsumer;
import org.apache.skywalking.apm.network.language.agent.UpstreamSegment;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;
import org.apache.skywalking.oap.server.library.buffer.BufferStream;
import org.apache.skywalking.oap.server.library.buffer.DataStreamReader;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.standardization.SegmentStandardization;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentStandardizationWorker
extends AbstractWorker<SegmentStandardization> {
    private static final Logger logger = LoggerFactory.getLogger(SegmentStandardizationWorker.class);
    private final DataCarrier<SegmentStandardization> dataCarrier;
    private CounterMetrics traceBufferFileIn;

    public SegmentStandardizationWorker(ModuleDefineHolder moduleDefineHolder, DataStreamReader.CallBack<UpstreamSegment> segmentParse, String path, int offsetFileMaxSize, int dataFileMaxSize, boolean cleanWhenRestart, boolean isV6) throws IOException {
        super(moduleDefineHolder);
        BufferStream.Builder builder = new BufferStream.Builder(path);
        builder.cleanWhenRestart(cleanWhenRestart);
        builder.dataFileMaxSize(dataFileMaxSize);
        builder.offsetFileMaxSize(offsetFileMaxSize);
        builder.parser(UpstreamSegment.parser());
        builder.callBack(segmentParse);
        BufferStream stream = builder.build();
        stream.initialize();
        this.dataCarrier = new DataCarrier("SegmentStandardizationWorker", 1, 1024);
        this.dataCarrier.consume((IConsumer)new Consumer(stream), 1, 200L);
        MetricsCreator metricsCreator = (MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class);
        String metricNamePrefix = isV6 ? "v6_" : "v5_";
        this.traceBufferFileIn = metricsCreator.createCounter(metricNamePrefix + "trace_buffer_file_in", "The number of trace segment into the buffer file", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
    }

    public void in(SegmentStandardization standardization) {
        this.dataCarrier.produce((Object)standardization);
    }

    private class Consumer
    implements IConsumer<SegmentStandardization> {
        private final BufferStream<UpstreamSegment> stream;

        private Consumer(BufferStream<UpstreamSegment> stream) {
            this.stream = stream;
        }

        public void init() {
        }

        public void consume(List<SegmentStandardization> data) {
            for (SegmentStandardization aData : data) {
                SegmentStandardizationWorker.this.traceBufferFileIn.inc();
                this.stream.write((AbstractMessageLite)aData.getUpstreamSegment());
            }
        }

        public void onError(List<SegmentStandardization> data, Throwable t) {
            logger.error(t.getMessage(), t);
        }

        public void onExit() {
        }
    }
}

