/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.handler.v8.rest;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.protobuf.Message;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.ProtoBufJsonUtils;
import org.apache.skywalking.oap.server.receiver.trace.provider.handler.v8.rest.TraceSegmentReportBaseServletHandler;

public class TraceSegmentReportListServletHandler
extends TraceSegmentReportBaseServletHandler {
    private final Gson gson = new Gson();

    public TraceSegmentReportListServletHandler(ModuleManager moduleManager) {
        super(moduleManager);
    }

    @Override
    protected List<SegmentObject> parseSegments(HttpServletRequest request) throws IOException {
        String line;
        BufferedReader reader = request.getReader();
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
        }
        JsonArray array = (JsonArray)this.gson.fromJson(stringBuilder.toString(), JsonArray.class);
        if (array.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SegmentObject> segments = new ArrayList<SegmentObject>(array.size());
        for (JsonElement element : array) {
            SegmentObject.Builder upstreamSegmentBuilder = SegmentObject.newBuilder();
            ProtoBufJsonUtils.fromJSON((String)element.toString(), (Message.Builder)upstreamSegmentBuilder);
            segments.add(upstreamSegmentBuilder.build());
        }
        return segments;
    }

    public String pathSpec() {
        return "/v3/segments";
    }
}

