/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.handler.v8.rest;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.ISegmentParserService;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.jetty.JettyJsonHandler;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TraceSegmentReportBaseServletHandler
extends JettyJsonHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TraceSegmentReportBaseServletHandler.class);
    private final ModuleManager moduleManager;
    private final ISegmentParserService segmentParserService;
    private HistogramMetrics histogram;
    private CounterMetrics errorCounter;

    public TraceSegmentReportBaseServletHandler(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
        this.segmentParserService = (ISegmentParserService)moduleManager.find("agent-analyzer").provider().getService(ISegmentParserService.class);
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.histogram = metricsCreator.createHistogramMetric("trace_in_latency", "The process latency of trace data", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"http"}), new double[0]);
        this.errorCounter = metricsCreator.createCounter("trace_analysis_error_count", "The error number of trace analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"http"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonElement doPost(HttpServletRequest req) {
        if (log.isDebugEnabled()) {
            log.debug("receive stream segment");
        }
        HistogramMetrics.Timer timer = this.histogram.createTimer();
        try {
            List<SegmentObject> segments = this.parseSegments(req);
            for (SegmentObject segment : segments) {
                this.segmentParserService.send(segment);
            }
        }
        catch (Exception e) {
            this.errorCounter.inc();
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            timer.finish();
        }
        return null;
    }

    protected abstract List<SegmentObject> parseSegments(HttpServletRequest var1) throws IOException;
}

