/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb;

import java.util.Properties;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.IRegisterLockDAO;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.StorageModule;
import org.apache.skywalking.oap.server.core.storage.cache.IEndpointInventoryCacheDAO;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressInventoryCacheDAO;
import org.apache.skywalking.oap.server.core.storage.cache.IServiceInstanceInventoryCacheDAO;
import org.apache.skywalking.oap.server.core.storage.cache.IServiceInventoryCacheDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.core.storage.ttl.GeneralStorageTTL;
import org.apache.skywalking.oap.server.core.storage.ttl.StorageTTL;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxStorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.base.BatchDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.base.HistoryDeleteDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.base.InfluxStorageDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.installer.H2Installer;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.installer.MySQLInstaller;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.AggregationQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.AlarmQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.LogQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.MetricsQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.ProfileTaskLogQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.ProfileTaskQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.ProfileThreadSnapshotQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.TopNRecordsQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.TopologyQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.TraceQuery;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2EndpointInventoryCacheDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2MetadataQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2NetworkAddressInventoryCacheDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2RegisterLockDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2RegisterLockInstaller;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ServiceInstanceInventoryCacheDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ServiceInventoryCacheDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxStorageProvider
extends ModuleProvider {
    private static final Logger log = LoggerFactory.getLogger(InfluxStorageProvider.class);
    private InfluxStorageConfig config = new InfluxStorageConfig();
    private JDBCHikariCPClient client;
    private InfluxClient influxClient;
    private H2RegisterLockDAO lockDAO;

    public String name() {
        return "influxdb";
    }

    public Class<? extends ModuleDefine> module() {
        return StorageModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException {
        Properties settings = "mysql".equalsIgnoreCase(this.config.getMetabaseType()) ? this.config.getMysqlProps() : this.config.getH2Props();
        this.client = new JDBCHikariCPClient(settings);
        this.influxClient = new InfluxClient(this.config);
        this.registerServiceImplementation(IBatchDAO.class, (Service)new BatchDAO(this.influxClient));
        this.registerServiceImplementation(StorageDAO.class, (Service)new InfluxStorageDAO(this.client, this.influxClient));
        this.lockDAO = new H2RegisterLockDAO(this.client);
        this.registerServiceImplementation(IRegisterLockDAO.class, (Service)new H2RegisterLockDAO(this.client));
        this.registerServiceImplementation(IServiceInventoryCacheDAO.class, (Service)new H2ServiceInventoryCacheDAO(this.client));
        this.registerServiceImplementation(IServiceInstanceInventoryCacheDAO.class, (Service)new H2ServiceInstanceInventoryCacheDAO(this.client));
        this.registerServiceImplementation(IEndpointInventoryCacheDAO.class, (Service)new H2EndpointInventoryCacheDAO(this.client));
        this.registerServiceImplementation(INetworkAddressInventoryCacheDAO.class, (Service)new H2NetworkAddressInventoryCacheDAO(this.client));
        this.registerServiceImplementation(IMetadataQueryDAO.class, (Service)new H2MetadataQueryDAO(this.client, this.config.getMetadataQueryMaxSize()));
        this.registerServiceImplementation(ITopologyQueryDAO.class, (Service)new TopologyQuery(this.influxClient));
        this.registerServiceImplementation(IMetricsQueryDAO.class, (Service)new MetricsQuery(this.influxClient));
        this.registerServiceImplementation(ITraceQueryDAO.class, (Service)new TraceQuery(this.influxClient));
        this.registerServiceImplementation(IAggregationQueryDAO.class, (Service)new AggregationQuery(this.influxClient));
        this.registerServiceImplementation(IAlarmQueryDAO.class, (Service)new AlarmQuery(this.influxClient));
        this.registerServiceImplementation(ITopNRecordsQueryDAO.class, (Service)new TopNRecordsQuery(this.influxClient));
        this.registerServiceImplementation(ILogQueryDAO.class, (Service)new LogQuery(this.influxClient));
        this.registerServiceImplementation(IProfileTaskQueryDAO.class, (Service)new ProfileTaskQuery(this.influxClient));
        this.registerServiceImplementation(IProfileThreadSnapshotQueryDAO.class, (Service)new ProfileThreadSnapshotQuery(this.influxClient));
        this.registerServiceImplementation(IProfileTaskLogQueryDAO.class, (Service)new ProfileTaskLogQuery(this.influxClient, this.config.getFetchTaskLogMaxSize()));
        this.registerServiceImplementation(IHistoryDeleteDAO.class, (Service)new HistoryDeleteDAO((ModuleDefineHolder)this.getManager(), this.influxClient, (StorageTTL)new GeneralStorageTTL()));
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        try {
            this.client.connect();
            this.influxClient.connect();
            Object installer = this.config.getMetabaseType().equalsIgnoreCase("h2") ? new H2Installer(this.getManager()) : new MySQLInstaller(this.getManager());
            installer.install((Client)this.client);
            new H2RegisterLockInstaller().install((Client)this.client, this.lockDAO);
        }
        catch (StorageException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

