/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.base;

import java.io.IOException;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.ttl.StorageTTL;
import org.apache.skywalking.oap.server.core.storage.ttl.TTLCalculator;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryDeleteDAO
implements IHistoryDeleteDAO {
    private static final Logger log = LoggerFactory.getLogger(HistoryDeleteDAO.class);
    private final ModuleDefineHolder moduleDefineHolder;
    private final InfluxClient client;
    private final StorageTTL storageTTL;

    public HistoryDeleteDAO(ModuleDefineHolder moduleDefineHolder, InfluxClient client, StorageTTL storageTTL) {
        this.moduleDefineHolder = moduleDefineHolder;
        this.storageTTL = storageTTL;
        this.client = client;
    }

    public void deleteHistory(Model model, String timeBucketColumnName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("TTL execution log, model: {}", (Object)model.getName());
        }
        try {
            ConfigService configService = (ConfigService)this.moduleDefineHolder.find("core").provider().getService(ConfigService.class);
            TTLCalculator ttlCalculator = model.isRecord() ? this.storageTTL.recordCalculator() : this.storageTTL.metricsCalculator(model.getDownsampling());
            this.client.deleteByQuery(model.getName(), TimeBucket.getTimestamp((long)(ttlCalculator.timeBefore(DateTime.now(), configService.getDataTTLConfig()) + 1L)));
        }
        catch (Exception e) {
            log.error("TTL execution log, model: {}, errMsg: {}", (Object)model.getName(), (Object)e.getMessage());
        }
    }
}

