/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.base;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.commons.datacarrier.common.AtomicRangeInteger;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.config.NoneStream;
import org.apache.skywalking.oap.server.core.storage.INoneStreamDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.base.InfluxInsertRequest;
import org.influxdb.dto.Point;

public class NoneStreamDAO
implements INoneStreamDAO {
    public static final String TAG_SERVICE_ID = "_service_id";
    private static final int PADDING_SIZE = 1000000;
    private static final AtomicRangeInteger SUFFIX = new AtomicRangeInteger(0, 1000000);
    private InfluxClient client;
    private StorageBuilder<NoneStream> storageBuilder;

    public NoneStreamDAO(InfluxClient client, StorageBuilder<NoneStream> storageBuilder) {
        this.client = client;
        this.storageBuilder = storageBuilder;
    }

    public void insert(Model model, NoneStream noneStream) throws IOException {
        long timestamp = TimeBucket.getTimestamp((long)noneStream.getTimeBucket(), (Downsampling)model.getDownsampling()) * 1000000L + (long)SUFFIX.getAndIncrement();
        Point point = new InfluxInsertRequest(model, (StorageData)noneStream, this.storageBuilder).time(timestamp, TimeUnit.NANOSECONDS).addFieldAsTag("service_id", TAG_SERVICE_ID).getPoint();
        this.client.write(point);
    }
}

