/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.query.entity.Order;
import org.apache.skywalking.oap.server.core.query.entity.TopNEntity;
import org.apache.skywalking.oap.server.core.storage.model.ModelName;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.SelectQueryImpl;
import org.influxdb.querybuilder.SelectSubQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationQuery
implements IAggregationQueryDAO {
    private static final Logger log = LoggerFactory.getLogger(AggregationQuery.class);
    private InfluxClient client;
    private static final Comparator<TopNEntity> ASCENDING = Comparator.comparingLong(TopNEntity::getValue);
    private static final Comparator<TopNEntity> DESCENDING = (a, b) -> Long.compare(b.getValue(), a.getValue());

    public AggregationQuery(InfluxClient client) {
        this.client = client;
    }

    public List<TopNEntity> getServiceTopN(String indName, String valueCName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        return this.getTopNEntity(downsampling, indName, this.subQuery(indName, valueCName, startTB, endTB), order, topN);
    }

    public List<TopNEntity> getAllServiceInstanceTopN(String indName, String valueCName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        return this.getTopNEntity(downsampling, indName, this.subQuery(indName, valueCName, startTB, endTB), order, topN);
    }

    public List<TopNEntity> getServiceInstanceTopN(int serviceId, String indName, String valueCName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        return this.getTopNEntity(downsampling, indName, this.subQuery("service_id", serviceId, indName, valueCName, startTB, endTB), order, topN);
    }

    public List<TopNEntity> getAllEndpointTopN(String indName, String valueCName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        return this.getTopNEntity(downsampling, indName, this.subQuery(indName, valueCName, startTB, endTB), order, topN);
    }

    public List<TopNEntity> getEndpointTopN(int serviceId, String indName, String valueCName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        return this.getTopNEntity(downsampling, indName, this.subQuery("service_id", serviceId, indName, valueCName, startTB, endTB), order, topN);
    }

    private List<TopNEntity> getTopNEntity(Downsampling downsampling, String name, SelectSubQueryImpl<SelectQueryImpl> subQuery, Order order, int topN) throws IOException {
        String measurement = ModelName.build((Downsampling)downsampling, (String)name);
        Comparator<TopNEntity> comparator = DESCENDING;
        String functionName = "top";
        if (order == Order.ASC) {
            functionName = "bottom";
            comparator = ASCENDING;
        }
        SelectQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).function(functionName, new Object[]{"mean", topN}).as("value").column("_entity_id").from(this.client.getDatabase(), measurement);
        query.setSubQuery(subQuery);
        List<QueryResult.Series> series = this.client.queryForSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), series);
        }
        if (series == null || series.isEmpty()) {
            return Collections.emptyList();
        }
        List dataset = series.get(0).getValues();
        ArrayList entities = Lists.newArrayListWithCapacity((int)dataset.size());
        dataset.forEach(values -> {
            TopNEntity entity = new TopNEntity();
            entity.setId((String)values.get(2));
            entity.setValue(((Double)values.get(1)).longValue());
            entities.add(entity);
        });
        Collections.sort(entities, comparator);
        return entities;
    }

    private SelectSubQueryImpl<SelectQueryImpl> subQuery(String serviceColumnName, int serviceId, String name, String columnName, long startTB, long endTB) {
        return (SelectSubQueryImpl)BuiltQuery.QueryBuilder.select((String[])new String[0]).fromSubQuery(this.client.getDatabase()).mean((Object)columnName).from(name).where().and(BuiltQuery.QueryBuilder.eq((String)serviceColumnName, (Object)serviceId)).and(BuiltQuery.QueryBuilder.gte((String)"time", (Object)InfluxClient.timeInterval(startTB))).and(BuiltQuery.QueryBuilder.lte((String)"time", (Object)InfluxClient.timeInterval(endTB))).groupBy(new Object[]{"_entity_id"});
    }

    private SelectSubQueryImpl<SelectQueryImpl> subQuery(String name, String columnName, long startTB, long endTB) {
        return (SelectSubQueryImpl)BuiltQuery.QueryBuilder.select((String[])new String[0]).fromSubQuery(this.client.getDatabase()).mean((Object)columnName).from(name).where().and(BuiltQuery.QueryBuilder.gte((String)"time", (Object)InfluxClient.timeInterval(startTB))).and(BuiltQuery.QueryBuilder.lte((String)"time", (Object)InfluxClient.timeInterval(endTB))).groupBy(new Object[]{"_entity_id"});
    }
}

