/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.query.entity.AlarmMessage;
import org.apache.skywalking.oap.server.core.query.entity.Alarms;
import org.apache.skywalking.oap.server.core.query.entity.Scope;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.elasticsearch.common.Strings;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.influxdb.querybuilder.clauses.Clause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmQuery
implements IAlarmQueryDAO {
    private static final Logger log = LoggerFactory.getLogger(AlarmQuery.class);
    private final InfluxClient client;

    public AlarmQuery(InfluxClient client) {
        this.client = client;
    }

    public Alarms getAlarm(Integer scopeId, String keyword, int limit, int from, long startTB, long endTB) throws IOException {
        WhereQueryImpl recallQuery = BuiltQuery.QueryBuilder.select((String[])new String[0]).function("top", new Object[]{"start_time", limit + from}).as("start_time").column("id0").column("alarm_message").column("scope").from(this.client.getDatabase(), "alarm_record").where();
        if (startTB > 0L && endTB > 0L) {
            recallQuery.and(BuiltQuery.QueryBuilder.gte((String)"time", (Object)InfluxClient.timeInterval(startTB))).and(BuiltQuery.QueryBuilder.lte((String)"time", (Object)InfluxClient.timeInterval(endTB)));
        }
        if (!Strings.isNullOrEmpty((String)keyword)) {
            recallQuery.and(BuiltQuery.QueryBuilder.contains((String)"alarm_message", (String)keyword.replaceAll("/", "\\\\/")));
        }
        if (Objects.nonNull(scopeId)) {
            recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"scope", (Object)scopeId));
        }
        WhereQueryImpl countQuery = BuiltQuery.QueryBuilder.select((String[])new String[0]).count((Object)"id0").from(this.client.getDatabase(), "alarm_record").where();
        recallQuery.getClauses().forEach(clause -> countQuery.where((Clause)clause));
        Query query = new Query(countQuery.getCommand() + recallQuery.getCommand());
        List<QueryResult.Result> results = this.client.query(query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), results);
        }
        if (results.size() != 2) {
            throw new IOException("Expecting to get 2 Results, but it is " + results.size());
        }
        List series = results.get(1).getSeries();
        if (series == null || series.isEmpty()) {
            return new Alarms();
        }
        List counter = results.get(0).getSeries();
        Alarms alarms = new Alarms();
        alarms.setTotal(((Number)((List)((QueryResult.Series)counter.get(0)).getValues().get(0)).get(1)).intValue());
        ((QueryResult.Series)series.get(0)).getValues().stream().sorted((a, b) -> Long.compare((Long)b.get(1), (Long)a.get(1))).skip(from).forEach(values -> {
            int sid = (Integer)values.get(4);
            Scope scope = Scope.Finder.valueOf((int)sid);
            AlarmMessage message = new AlarmMessage();
            message.setStartTime(Long.valueOf((Long)values.get(1)));
            message.setId((String)values.get(2));
            message.setMessage((String)values.get(3));
            message.setScope(scope);
            message.setScopeId(sid);
            alarms.getMsgs().add(message);
        });
        return alarms;
    }
}

