/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValue;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValueHashMap;
import org.apache.skywalking.oap.server.core.query.entity.IntValues;
import org.apache.skywalking.oap.server.core.query.entity.KVInt;
import org.apache.skywalking.oap.server.core.query.entity.Thermodynamic;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.query.sql.KeyValues;
import org.apache.skywalking.oap.server.core.query.sql.Where;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.model.ModelName;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.TableMetaInfo;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.SelectionQueryImpl;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsQuery
implements IMetricsQueryDAO {
    private static final Logger log = LoggerFactory.getLogger(MetricsQuery.class);
    private final InfluxClient client;

    public MetricsQuery(InfluxClient client) {
        this.client = client;
    }

    public IntValues getValues(String indName, Downsampling downsampling, long startTB, long endTB, Where where, String valueCName, Function function) throws IOException {
        Object value;
        String measurement = ModelName.build((Downsampling)downsampling, (String)indName);
        SelectionQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]);
        switch (function) {
            case Avg: {
                query.mean((Object)valueCName);
                break;
            }
            default: {
                query.sum((Object)valueCName);
            }
        }
        WhereQueryImpl queryWhereQuery = query.from(this.client.getDatabase(), measurement).where();
        HashMap columnTypes = Maps.newHashMap();
        for (ModelColumn column : TableMetaInfo.get((String)measurement).getColumns()) {
            columnTypes.put(column.getColumnName().getStorageName(), column.getType());
        }
        ArrayList<String> ids = new ArrayList<String>(20);
        List whereKeyValues = where.getKeyValues();
        if (!whereKeyValues.isEmpty()) {
            StringBuilder clauseBuilder = new StringBuilder();
            for (KeyValues kv : whereKeyValues) {
                List values = kv.getValues();
                Class type = (Class)columnTypes.get(kv.getKey());
                if (values.size() == 1) {
                    value = (String)kv.getValues().get(0);
                    if (type == String.class) {
                        value = "'" + (String)value + "'";
                    }
                    clauseBuilder.append(kv.getKey()).append("=").append((String)value).append(" OR ");
                    continue;
                }
                ids.addAll(values);
                if (type == String.class) {
                    clauseBuilder.append(kv.getKey()).append(" =~ /").append(Joiner.on((String)"|").join((Iterable)values)).append("/ OR ");
                    continue;
                }
                for (String value2 : values) {
                    clauseBuilder.append(kv.getKey()).append(" = '").append(value2).append("' OR ");
                }
            }
            queryWhereQuery.where(clauseBuilder.substring(0, clauseBuilder.length() - 4));
        }
        queryWhereQuery.and(BuiltQuery.QueryBuilder.gte((String)"time", (Object)InfluxClient.timeInterval(startTB, downsampling))).and(BuiltQuery.QueryBuilder.lte((String)"time", (Object)InfluxClient.timeInterval(endTB, downsampling))).groupBy(new Object[]{"_entity_id"});
        IntValues intValues = new IntValues();
        List<QueryResult.Series> seriesList = this.client.queryForSeries((Query)queryWhereQuery);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)queryWhereQuery.getCommand(), seriesList);
        }
        if (seriesList != null && !seriesList.isEmpty()) {
            for (QueryResult.Series series : seriesList) {
                KVInt kv = new KVInt();
                kv.setId((String)series.getTags().get("_entity_id"));
                value = (Number)((List)series.getValues().get(0)).get(1);
                kv.setValue(((Number)value).longValue());
                intValues.addKVInt(kv);
            }
        }
        return this.orderWithDefault0(intValues, ids);
    }

    public IntValues getLinearIntValues(String indName, Downsampling downsampling, List<String> ids, String valueCName) throws IOException {
        String measurement = ModelName.build((Downsampling)downsampling, (String)indName);
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).column("id").column(valueCName).from(this.client.getDatabase(), measurement).where();
        if (ids != null && !ids.isEmpty()) {
            if (ids.size() == 1) {
                query.where(BuiltQuery.QueryBuilder.eq((String)"id", (Object)ids.get(0)));
            } else {
                query.where(BuiltQuery.QueryBuilder.contains((String)"id", (String)Joiner.on((String)"|").join(ids)));
            }
        }
        List<QueryResult.Series> seriesList = this.client.queryForSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), seriesList);
        }
        IntValues intValues = new IntValues();
        if (seriesList != null && !seriesList.isEmpty()) {
            seriesList.get(0).getValues().forEach(values -> {
                KVInt kv = new KVInt();
                kv.setValue(((Number)values.get(2)).longValue());
                kv.setId((String)values.get(1));
                intValues.addKVInt(kv);
            });
        }
        return this.orderWithDefault0(intValues, ids);
    }

    private IntValues orderWithDefault0(IntValues origin, List<String> expectedOrder) {
        IntValues intValues = new IntValues();
        expectedOrder.forEach(id -> {
            KVInt e = new KVInt();
            e.setId(id);
            e.setValue(origin.findValue(id, 0));
            intValues.addKVInt(e);
        });
        return intValues;
    }

    public IntValues[] getMultipleLinearIntValues(String indName, Downsampling downsampling, List<String> ids, List<Integer> linearIndex, String valueCName) throws IOException {
        String measurement = ModelName.build((Downsampling)downsampling, (String)indName);
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).column("id").column(valueCName).from(this.client.getDatabase(), measurement).where();
        if (ids != null && !ids.isEmpty()) {
            if (ids.size() == 1) {
                query.where(BuiltQuery.QueryBuilder.eq((String)"id", (Object)ids.get(0)));
            } else {
                query.where(BuiltQuery.QueryBuilder.contains((String)"id", (String)Joiner.on((String)"|").join(ids)));
            }
        }
        List<QueryResult.Series> series = this.client.queryForSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), series);
        }
        IntValues[] intValues = new IntValues[linearIndex.size()];
        for (int i = 0; i < intValues.length; ++i) {
            intValues[i] = new IntValues();
        }
        if (series == null || series.isEmpty()) {
            return intValues;
        }
        series.get(0).getValues().forEach(values -> {
            IntKeyLongValueHashMap multipleValues = new IntKeyLongValueHashMap(5);
            multipleValues.toObject((String)values.get(2));
            String id = (String)values.get(1);
            for (int i = 0; i < intValues.length; ++i) {
                Integer index = (Integer)linearIndex.get(i);
                KVInt kv = new KVInt();
                kv.setId(id);
                kv.setValue(((IntKeyLongValue)multipleValues.get((Object)index)).getValue());
                intValues[i].addKVInt(kv);
            }
        });
        return this.orderWithDefault0(intValues, ids);
    }

    private IntValues[] orderWithDefault0(IntValues[] origin, List<String> expectedOrder) {
        for (int i = 0; i < origin.length; ++i) {
            origin[i] = this.orderWithDefault0(origin[i], expectedOrder);
        }
        return origin;
    }

    public Thermodynamic getThermodynamic(String indName, Downsampling downsampling, List<String> ids, String valueCName) throws IOException {
        String measurement = ModelName.build((Downsampling)downsampling, (String)indName);
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).column("step").column("num_of_steps").column("detail_group").column("id").from(this.client.getDatabase(), measurement).where(BuiltQuery.QueryBuilder.contains((String)"id", (String)Joiner.on((String)"|").join(ids)));
        HashMap thermodynamicValueMatrix = new HashMap();
        QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), (Object)series);
        }
        if (series == null) {
            return new Thermodynamic();
        }
        int numOfSteps = 0;
        int axisYStep = 0;
        ArrayList thermodynamicValueCollection = new ArrayList();
        Thermodynamic thermodynamic = new Thermodynamic();
        for (List values : series.getValues()) {
            numOfSteps = (Integer)values.get(2) + 1;
            axisYStep = (Integer)values.get(1);
            IntKeyLongValueHashMap intKeyLongValues = new IntKeyLongValueHashMap(5);
            intKeyLongValues.toObject((String)values.get(3));
            ArrayList<Long> axisYValues = new ArrayList<Long>(numOfSteps);
            for (int i = 0; i < numOfSteps; ++i) {
                axisYValues.add(0L);
            }
            for (IntKeyLongValue intKeyLongValue : intKeyLongValues.values()) {
                axisYValues.set(intKeyLongValue.getKey(), intKeyLongValue.getValue());
            }
            thermodynamicValueMatrix.put((String)values.get(4), axisYValues);
        }
        ids.forEach(id -> {
            if (thermodynamicValueMatrix.containsKey(id)) {
                thermodynamicValueCollection.add(thermodynamicValueMatrix.get(id));
            } else {
                thermodynamicValueCollection.add(new ArrayList());
            }
        });
        thermodynamic.fromMatrixData(thermodynamicValueCollection, numOfSteps);
        thermodynamic.setAxisYStep(axisYStep);
        return thermodynamic;
    }
}

