/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.query.entity.ProfileTaskLog;
import org.apache.skywalking.oap.server.core.query.entity.ProfileTaskLogOperationType;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileTaskLogQuery
implements IProfileTaskLogQueryDAO {
    private static final Logger log = LoggerFactory.getLogger(ProfileTaskLogQuery.class);
    private InfluxClient client;
    private int fetchTaskLogMaxSize;

    public ProfileTaskLogQuery(InfluxClient client, int fetchTaskLogMaxSize) {
        this.client = client;
        this.fetchTaskLogMaxSize = fetchTaskLogMaxSize;
    }

    public List<ProfileTaskLog> getTaskLogList(String taskId) throws IOException {
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).function("top", new Object[]{"operation_time", this.fetchTaskLogMaxSize}).column("id").column("task_id").column("instance_id").column("operation_time").column("operation_type").from(this.client.getDatabase(), "profile_task_log").where();
        if (StringUtil.isNotEmpty((String)taskId)) {
            query.and(BuiltQuery.QueryBuilder.eq((String)"task_id", (Object)taskId));
        }
        QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), (Object)series);
        }
        if (series == null) {
            return Collections.emptyList();
        }
        List columns = series.getColumns();
        HashMap columnsMap = Maps.newHashMap();
        for (int i = 0; i < columns.size(); ++i) {
            columnsMap.put(columns.get(i), i);
        }
        ArrayList taskLogs = Lists.newArrayList();
        series.getValues().stream().sorted((a, b) -> Long.compare(((Number)b.get(1)).longValue(), ((Number)a.get(1)).longValue())).forEach(values -> taskLogs.add(ProfileTaskLog.builder().id((String)values.get((Integer)columnsMap.get("id"))).taskId((String)values.get((Integer)columnsMap.get("task_id"))).instanceId(((Integer)values.get((Integer)columnsMap.get("instance_id"))).intValue()).operationTime(((Long)values.get((Integer)columnsMap.get("operation_time"))).longValue()).operationType(ProfileTaskLogOperationType.parse((int)((Integer)values.get((Integer)columnsMap.get("operation_type"))))).build()));
        return taskLogs;
    }
}

