/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.skywalking.oap.server.core.query.entity.Order;
import org.apache.skywalking.oap.server.core.query.entity.TopNRecord;
import org.apache.skywalking.oap.server.core.storage.query.ITopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopNRecordsQuery
implements ITopNRecordsQueryDAO {
    private static final Logger log = LoggerFactory.getLogger(TopNRecordsQuery.class);
    private final InfluxClient client;

    public TopNRecordsQuery(InfluxClient client) {
        this.client = client;
    }

    public List<TopNRecord> getTopNRecords(long startSecondTB, long endSecondTB, String metricName, int serviceId, int topN, Order order) throws IOException {
        String function = "bottom";
        Comparator comparator = Comparator.comparingLong(TopNRecord::getLatency);
        if (order.equals((Object)Order.DES)) {
            function = "top";
            comparator = (a, b) -> Long.compare(b.getLatency(), a.getLatency());
        }
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).function(function, new Object[]{"latency", topN}).column("statement").column("trace_id").from(this.client.getDatabase(), metricName).where().and(BuiltQuery.QueryBuilder.gte((String)"time_bucket", (Object)startSecondTB)).and(BuiltQuery.QueryBuilder.lte((String)"time_bucket", (Object)endSecondTB));
        if (serviceId != 0) {
            query.and(BuiltQuery.QueryBuilder.eq((String)"_service_id", (Object)String.valueOf(serviceId)));
        }
        QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), (Object)series);
        }
        if (series == null) {
            return Collections.emptyList();
        }
        ArrayList<TopNRecord> records = new ArrayList<TopNRecord>();
        series.getValues().forEach(values -> {
            TopNRecord record = new TopNRecord();
            record.setLatency(((Long)values.get(1)).longValue());
            record.setTraceId((String)values.get(3));
            record.setStatement((String)values.get(2));
            records.add(record);
        });
        Collections.sort(records, comparator);
        return records;
    }
}

