/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.analysis.manual.RelationDefineUtil;
import org.apache.skywalking.oap.server.core.query.entity.Call;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.storage.model.ModelName;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.WhereNested;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyQuery
implements ITopologyQueryDAO {
    private static final Logger log = LoggerFactory.getLogger(TopologyQuery.class);
    private final InfluxClient client;

    public TopologyQuery(InfluxClient client) {
        this.client = client;
    }

    public List<Call.CallDetail> loadSpecifiedServerSideServiceRelations(Downsampling downsampling, long startTB, long endTB, List<Integer> serviceIds) throws IOException {
        String measurement = ModelName.build((Downsampling)downsampling, (String)"service_relation_server_side");
        WhereQueryImpl query = this.buildServiceCallsQuery(measurement, startTB, endTB, "source_service_id", "dest_service_id", serviceIds);
        return this.buildCalls(query, DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadSpecifiedClientSideServiceRelations(Downsampling downsampling, long startTB, long endTB, List<Integer> serviceIds) throws IOException {
        String measurement = ModelName.build((Downsampling)downsampling, (String)"service_relation_client_side");
        WhereQueryImpl query = this.buildServiceCallsQuery(measurement, startTB, endTB, "source_service_id", "dest_service_id", serviceIds);
        return this.buildCalls(query, DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadServerSideServiceRelations(Downsampling downsampling, long startTB, long endTB) throws IOException {
        String measurement = ModelName.build((Downsampling)downsampling, (String)"service_relation_server_side");
        WhereQueryImpl query = this.buildServiceCallsQuery(measurement, startTB, endTB, "source_service_id", "dest_service_id", new ArrayList<Integer>(0));
        return this.buildCalls(query, DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadClientSideServiceRelations(Downsampling downsampling, long startTB, long endTB) throws IOException {
        String tableName = ModelName.build((Downsampling)downsampling, (String)"service_relation_client_side");
        WhereQueryImpl query = this.buildServiceCallsQuery(tableName, startTB, endTB, "source_service_id", "dest_service_id", new ArrayList<Integer>(0));
        return this.buildCalls(query, DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadServerSideServiceInstanceRelations(int clientServiceId, int serverServiceId, Downsampling downsampling, long startTB, long endTB) throws IOException {
        String measurement = ModelName.build((Downsampling)downsampling, (String)"service_instance_relation_server_side");
        WhereQueryImpl query = this.buildServiceInstanceCallsQuery(measurement, startTB, endTB, "source_service_id", "dest_service_id", clientServiceId, serverServiceId);
        return this.buildCalls(query, DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadClientSideServiceInstanceRelations(int clientServiceId, int serverServiceId, Downsampling downsampling, long startTB, long endTB) throws IOException {
        String measurement = ModelName.build((Downsampling)downsampling, (String)"service_instance_relation_client_side");
        WhereQueryImpl query = this.buildServiceInstanceCallsQuery(measurement, startTB, endTB, "source_service_id", "dest_service_id", clientServiceId, serverServiceId);
        return this.buildCalls(query, DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadSpecifiedDestOfServerSideEndpointRelations(Downsampling downsampling, long startTB, long endTB, int destEndpointId) throws IOException {
        String measurement = ModelName.build((Downsampling)downsampling, (String)"endpoint_relation_server_side");
        WhereQueryImpl query = this.buildServiceCallsQuery(measurement, startTB, endTB, "source_endpoint_id", "dest_endpoint_id", Collections.emptyList());
        query.and(BuiltQuery.QueryBuilder.eq((String)"dest_endpoint_id", (Object)destEndpointId));
        WhereQueryImpl query2 = this.buildServiceCallsQuery(measurement, startTB, endTB, "source_endpoint_id", "dest_endpoint_id", Collections.emptyList());
        query2.and(BuiltQuery.QueryBuilder.eq((String)"source_endpoint_id", (Object)destEndpointId));
        List<Call.CallDetail> calls = this.buildCalls(query, DetectPoint.SERVER);
        calls.addAll(this.buildCalls(query2, DetectPoint.CLIENT));
        return calls;
    }

    private WhereQueryImpl buildServiceCallsQuery(String measurement, long startTB, long endTB, String sourceCName, String destCName, List<Integer> serviceIds) {
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).function("distinct", new Object[]{"entity_id"}).from(this.client.getDatabase(), measurement).where().and(BuiltQuery.QueryBuilder.gte((String)"time", (Object)InfluxClient.timeInterval(startTB))).and(BuiltQuery.QueryBuilder.lte((String)"time", (Object)InfluxClient.timeInterval(endTB)));
        if (!serviceIds.isEmpty()) {
            WhereNested whereNested = query.andNested();
            for (Integer id : serviceIds) {
                whereNested.or(BuiltQuery.QueryBuilder.eq((String)sourceCName, (Object)id)).or(BuiltQuery.QueryBuilder.eq((String)destCName, (Object)id));
            }
            whereNested.close();
        }
        return query;
    }

    private WhereQueryImpl buildServiceInstanceCallsQuery(String measurement, long startTB, long endTB, String sourceCName, String destCName, int sourceServiceId, int destServiceId) {
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).function("distinct", new Object[]{"entity_id"}).from(this.client.getDatabase(), measurement).where().and(BuiltQuery.QueryBuilder.gte((String)"time", (Object)InfluxClient.timeInterval(startTB))).and(BuiltQuery.QueryBuilder.lte((String)"time", (Object)InfluxClient.timeInterval(endTB)));
        StringBuilder builder = new StringBuilder("((");
        builder.append(sourceCName).append("=").append(sourceServiceId).append(" and ").append(destCName).append("=").append(destServiceId).append(") or (").append(sourceCName).append("=").append(destServiceId).append(") and (").append(destCName).append("=").append(sourceServiceId).append("))");
        query.where(builder.toString());
        return query;
    }

    private List<Call.CallDetail> buildCalls(WhereQueryImpl query, DetectPoint detectPoint) throws IOException {
        QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), (Object)series);
        }
        if (series == null) {
            return Collections.emptyList();
        }
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        series.getValues().forEach(values -> {
            Call.CallDetail call = new Call.CallDetail();
            String entityId = (String)values.get(1);
            RelationDefineUtil.RelationDefine relationDefine = RelationDefineUtil.splitEntityId((String)entityId);
            call.setSource(Integer.valueOf(relationDefine.getSource()));
            call.setTarget(Integer.valueOf(relationDefine.getDest()));
            call.setComponentId(Integer.valueOf(relationDefine.getComponentId()));
            call.setDetectPoint(detectPoint);
            call.generateID();
            calls.add(call);
        });
        return calls;
    }
}

