/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.base;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.commons.datacarrier.common.AtomicRangeInteger;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.TableMetaInfo;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.base.InfluxInsertRequest;

public class RecordDAO
implements IRecordDAO {
    private static final int PADDING_SIZE = 1000000;
    private static final AtomicRangeInteger SUFFIX = new AtomicRangeInteger(0, 1000000);
    private InfluxClient client;
    private StorageBuilder<Record> storageBuilder;

    public RecordDAO(InfluxClient client, StorageBuilder<Record> storageBuilder) {
        this.client = client;
        this.storageBuilder = storageBuilder;
    }

    public InsertRequest prepareBatchInsert(Model model, Record record) throws IOException {
        long timestamp = TimeBucket.getTimestamp((long)record.getTimeBucket(), (DownSampling)model.getDownsampling()) * 1000000L + (long)SUFFIX.getAndIncrement();
        InfluxInsertRequest request = new InfluxInsertRequest(model, (StorageData)record, this.storageBuilder).time(timestamp, TimeUnit.NANOSECONDS);
        TableMetaInfo.get(model.getName()).getStorageAndTagMap().forEach((field, tag) -> request.addFieldAsTag((String)field, (String)tag));
        return request;
    }
}

