/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.manual.networkalias.NetworkAddressAlias;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.TableMetaInfo;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAddressAliasDAO
implements INetworkAddressAliasDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetworkAddressAliasDAO.class);
    private final NetworkAddressAlias.Builder builder = new NetworkAddressAlias.Builder();
    private InfluxClient client;

    public NetworkAddressAliasDAO(InfluxClient client) {
        this.client = client;
    }

    public List<NetworkAddressAlias> loadLastUpdate(long timeBucket) {
        ArrayList<NetworkAddressAlias> networkAddressAliases = new ArrayList<NetworkAddressAlias>();
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).raw("*::field").from(this.client.getDatabase(), "network_address_alias").where(BuiltQuery.QueryBuilder.gte((String)"last_update_time_bucket", (Object)timeBucket));
        try {
            QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
            if (log.isDebugEnabled()) {
                log.debug("SQL: {} result: {}", (Object)query.getCommand(), (Object)series);
            }
            if (Objects.isNull(series)) {
                return networkAddressAliases;
            }
            List result = series.getValues();
            List columns = series.getColumns();
            Map<String, String> columnAndFieldMap = TableMetaInfo.get("network_address_alias").getStorageAndColumnMap();
            for (List values : result) {
                HashMap map = Maps.newHashMap();
                for (int i = 1; i < columns.size(); ++i) {
                    map.put(columnAndFieldMap.get(columns.get(i)), values.get(i));
                }
                networkAddressAliases.add(this.builder.map2Data((Map)map));
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return networkAddressAliases;
    }
}

