/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.model.ColumnName;
import org.apache.skywalking.oap.server.core.storage.model.Model;

public class TableMetaInfo {
    private static final Map<String, TableMetaInfo> TABLES = new HashMap<String, TableMetaInfo>();
    private Map<String, String> storageAndColumnMap;
    private Map<String, String> storageAndTagMap;
    private Model model;

    public static void addModel(Model model) {
        List columns = model.getColumns();
        HashMap storageAndTagMap = Maps.newHashMap();
        HashMap storageAndColumnMap = Maps.newHashMap();
        columns.forEach(column -> {
            ColumnName columnName = column.getColumnName();
            storageAndColumnMap.put(columnName.getStorageName(), columnName.getName());
        });
        if (model.getName().endsWith("_traffic")) {
            storageAndTagMap.put("name", "_name");
            if ("instance_traffic".equals(model.getName()) || "endpoint_traffic".equals(model.getName())) {
                storageAndTagMap.put("service_id", "_service_id");
            } else {
                storageAndTagMap.put("node_type", "_node_type");
            }
        } else {
            if (storageAndColumnMap.containsKey("entity_id")) {
                storageAndTagMap.put("entity_id", "_entity_id");
            }
            if (storageAndColumnMap.containsKey("time_bucket")) {
                storageAndTagMap.put("time_bucket", "_time_bucket");
            }
            if (storageAndColumnMap.containsKey("node_type")) {
                storageAndTagMap.put("node_type", "_node_type");
            }
            if (storageAndColumnMap.containsKey("service_id")) {
                storageAndTagMap.put("service_id", "_service_id");
            }
        }
        TableMetaInfo info = TableMetaInfo.builder().model(model).storageAndTagMap(storageAndTagMap).storageAndColumnMap(storageAndColumnMap).build();
        TABLES.put(model.getName(), info);
    }

    public static TableMetaInfo get(String moduleName) {
        return TABLES.get(moduleName);
    }

    @Generated
    public static TableMetaInfoBuilder builder() {
        return new TableMetaInfoBuilder();
    }

    @Generated
    public Map<String, String> getStorageAndColumnMap() {
        return this.storageAndColumnMap;
    }

    @Generated
    public Map<String, String> getStorageAndTagMap() {
        return this.storageAndTagMap;
    }

    @Generated
    public Model getModel() {
        return this.model;
    }

    @Generated
    public TableMetaInfo(Map<String, String> storageAndColumnMap, Map<String, String> storageAndTagMap, Model model) {
        this.storageAndColumnMap = storageAndColumnMap;
        this.storageAndTagMap = storageAndTagMap;
        this.model = model;
    }

    @Generated
    public static class TableMetaInfoBuilder {
        @Generated
        private Map<String, String> storageAndColumnMap;
        @Generated
        private Map<String, String> storageAndTagMap;
        @Generated
        private Model model;

        @Generated
        TableMetaInfoBuilder() {
        }

        @Generated
        public TableMetaInfoBuilder storageAndColumnMap(Map<String, String> storageAndColumnMap) {
            this.storageAndColumnMap = storageAndColumnMap;
            return this;
        }

        @Generated
        public TableMetaInfoBuilder storageAndTagMap(Map<String, String> storageAndTagMap) {
            this.storageAndTagMap = storageAndTagMap;
            return this;
        }

        @Generated
        public TableMetaInfoBuilder model(Model model) {
            this.model = model;
            return this;
        }

        @Generated
        public TableMetaInfo build() {
            return new TableMetaInfo(this.storageAndColumnMap, this.storageAndTagMap, this.model);
        }

        @Generated
        public String toString() {
            return "TableMetaInfo.TableMetaInfoBuilder(storageAndColumnMap=" + this.storageAndColumnMap + ", storageAndTagMap=" + this.storageAndTagMap + ", model=" + this.model + ")";
        }
    }
}

