/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.base;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.UpdateRequest;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.TableMetaInfo;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.base.InfluxInsertRequest;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsDAO
implements IMetricsDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsDAO.class);
    private final StorageBuilder<Metrics> storageBuilder;
    private final InfluxClient client;

    public MetricsDAO(InfluxClient client, StorageBuilder<Metrics> storageBuilder) {
        this.client = client;
        this.storageBuilder = storageBuilder;
    }

    public List<Metrics> multiGet(Model model, List<String> ids) throws IOException {
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).raw("*::field").from(this.client.getDatabase(), model.getName()).where(BuiltQuery.QueryBuilder.contains((String)"id", (String)Joiner.on((String)"|").join(ids)));
        QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result: {}", (Object)query.getCommand(), (Object)series);
        }
        if (series == null) {
            return Collections.emptyList();
        }
        ArrayList metrics = Lists.newArrayList();
        List columns = series.getColumns();
        TableMetaInfo metaInfo = TableMetaInfo.get(model.getName());
        Map<String, String> storageAndColumnMap = metaInfo.getStorageAndColumnMap();
        series.getValues().forEach(values -> {
            HashMap data = Maps.newHashMap();
            for (int i = 1; i < columns.size(); ++i) {
                Object value = values.get(i);
                if (value instanceof StorageDataComplexObject) {
                    value = ((StorageDataComplexObject)value).toStorageData();
                }
                data.put(storageAndColumnMap.get(columns.get(i)), value);
            }
            metrics.add(this.storageBuilder.map2Data((Map)data));
        });
        return metrics;
    }

    public InsertRequest prepareBatchInsert(Model model, Metrics metrics) throws IOException {
        long timestamp = TimeBucket.getTimestamp((long)metrics.getTimeBucket(), (DownSampling)model.getDownsampling());
        TableMetaInfo tableMetaInfo = TableMetaInfo.get(model.getName());
        InfluxInsertRequest request = new InfluxInsertRequest(model, (StorageData)metrics, this.storageBuilder).time(timestamp, TimeUnit.MILLISECONDS);
        tableMetaInfo.getStorageAndTagMap().forEach((field, tag) -> request.addFieldAsTag((String)field, (String)tag));
        return request;
    }

    public UpdateRequest prepareBatchUpdate(Model model, Metrics metrics) throws IOException {
        return (UpdateRequest)this.prepareBatchInsert(model, metrics);
    }
}

