/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.type.Call;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.QueryStringBuilder;
import org.influxdb.querybuilder.SelectQueryImpl;
import org.influxdb.querybuilder.SelectSubQueryImpl;
import org.influxdb.querybuilder.WhereNested;
import org.influxdb.querybuilder.WhereSubQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyQuery
implements ITopologyQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopologyQuery.class);
    private final InfluxClient client;

    public TopologyQuery(InfluxClient client) {
        this.client = client;
    }

    public List<Call.CallDetail> loadServiceRelationsDetectedAtServerSide(long startTB, long endTB, List<String> serviceIds) throws IOException {
        String measurement = "service_relation_server_side";
        WhereSubQueryImpl<SelectSubQueryImpl<SelectQueryImpl>, SelectQueryImpl> subQuery = this.buildServiceCallsQuery(measurement, startTB, endTB, "source_service_id", "dest_service_id", serviceIds);
        return this.buildServiceCalls(this.buildQuery(subQuery), DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadServiceRelationDetectedAtClientSide(long startTB, long endTB, List<String> serviceIds) throws IOException {
        String measurement = "service_relation_client_side";
        WhereSubQueryImpl<SelectSubQueryImpl<SelectQueryImpl>, SelectQueryImpl> subQuery = this.buildServiceCallsQuery(measurement, startTB, endTB, "source_service_id", "dest_service_id", serviceIds);
        return this.buildServiceCalls(this.buildQuery(subQuery), DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadServiceRelationsDetectedAtServerSide(long startTB, long endTB) throws IOException {
        String measurement = "service_relation_server_side";
        WhereSubQueryImpl<SelectSubQueryImpl<SelectQueryImpl>, SelectQueryImpl> subQuery = this.buildServiceCallsQuery(measurement, startTB, endTB, "source_service_id", "dest_service_id", new ArrayList<String>(0));
        return this.buildServiceCalls(this.buildQuery(subQuery), DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadServiceRelationDetectedAtClientSide(long startTB, long endTB) throws IOException {
        String tableName = "service_relation_client_side";
        WhereSubQueryImpl<SelectSubQueryImpl<SelectQueryImpl>, SelectQueryImpl> subQuery = this.buildServiceCallsQuery(tableName, startTB, endTB, "source_service_id", "dest_service_id", new ArrayList<String>(0));
        return this.buildServiceCalls(this.buildQuery(subQuery), DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadInstanceRelationDetectedAtServerSide(String clientServiceId, String serverServiceId, long startTB, long endTB) throws IOException {
        String measurement = "service_instance_relation_server_side";
        WhereSubQueryImpl<SelectSubQueryImpl<SelectQueryImpl>, SelectQueryImpl> subQuery = this.buildServiceInstanceCallsQuery(measurement, startTB, endTB, "source_service_id", "dest_service_id", clientServiceId, serverServiceId);
        return this.buildInstanceCalls(this.buildQuery(subQuery), DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadInstanceRelationDetectedAtClientSide(String clientServiceId, String serverServiceId, long startTB, long endTB) throws IOException {
        String measurement = "service_instance_relation_client_side";
        WhereSubQueryImpl<SelectSubQueryImpl<SelectQueryImpl>, SelectQueryImpl> subQuery = this.buildServiceInstanceCallsQuery(measurement, startTB, endTB, "source_service_id", "dest_service_id", clientServiceId, serverServiceId);
        return this.buildInstanceCalls(this.buildQuery(subQuery), DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadEndpointRelation(long startTB, long endTB, String destEndpointId) throws IOException {
        String measurement = "endpoint_relation_server_side";
        WhereSubQueryImpl<SelectSubQueryImpl<SelectQueryImpl>, SelectQueryImpl> subQuery = this.buildServiceCallsQuery(measurement, startTB, endTB, "source_endpoint", "dest_endpoint", Collections.emptyList());
        subQuery.and(BuiltQuery.QueryBuilder.eq((String)"dest_endpoint", (Object)destEndpointId));
        WhereSubQueryImpl<SelectSubQueryImpl<SelectQueryImpl>, SelectQueryImpl> subQuery2 = this.buildServiceCallsQuery(measurement, startTB, endTB, "source_endpoint", "dest_endpoint", Collections.emptyList());
        subQuery2.and(BuiltQuery.QueryBuilder.eq((String)"source_endpoint", (Object)destEndpointId));
        List<Call.CallDetail> calls = this.buildEndpointCalls(this.buildQuery(subQuery), DetectPoint.SERVER);
        calls.addAll(this.buildEndpointCalls(this.buildQuery(subQuery), DetectPoint.CLIENT));
        return calls;
    }

    private WhereSubQueryImpl<SelectSubQueryImpl<SelectQueryImpl>, SelectQueryImpl> buildServiceCallsQuery(String measurement, long startTB, long endTB, String sourceCName, String destCName, List<String> serviceIds) {
        WhereSubQueryImpl subQuery = BuiltQuery.QueryBuilder.select((String[])new String[0]).fromSubQuery(this.client.getDatabase()).function("distinct", new Object[]{"component_id"}).as("component_id").from(measurement).where().and(BuiltQuery.QueryBuilder.gte((String)"time", (Object)InfluxClient.timeIntervalTB(startTB))).and(BuiltQuery.QueryBuilder.lte((String)"time", (Object)InfluxClient.timeIntervalTB(endTB)));
        if (!serviceIds.isEmpty()) {
            WhereNested whereNested = subQuery.andNested();
            for (String id : serviceIds) {
                whereNested.or(BuiltQuery.QueryBuilder.eq((String)sourceCName, (Object)id)).or(BuiltQuery.QueryBuilder.eq((String)destCName, (Object)id));
            }
            whereNested.close();
        }
        return subQuery;
    }

    private WhereSubQueryImpl<SelectSubQueryImpl<SelectQueryImpl>, SelectQueryImpl> buildServiceInstanceCallsQuery(String measurement, long startTB, long endTB, String sourceCName, String destCName, String sourceServiceId, String destServiceId) {
        WhereSubQueryImpl subQuery = BuiltQuery.QueryBuilder.select((String[])new String[0]).fromSubQuery(this.client.getDatabase()).function("distinct", new Object[]{"component_id"}).as("component_id").from(measurement).where().and(BuiltQuery.QueryBuilder.gte((String)"time", (Object)InfluxClient.timeIntervalTB(startTB))).and(BuiltQuery.QueryBuilder.lte((String)"time", (Object)InfluxClient.timeIntervalTB(endTB)));
        StringBuilder builder = new StringBuilder("((");
        builder.append(sourceCName).append("='").append(sourceServiceId).append("' and ").append(destCName).append("='").append(destServiceId).append("') or (").append(sourceCName).append("='").append(destServiceId).append("') and (").append(destCName).append("='").append(sourceServiceId).append("'))");
        subQuery.where(builder.toString());
        subQuery.groupBy(new Object[]{"_entity_id"});
        return subQuery;
    }

    private List<Call.CallDetail> buildServiceCalls(Query query, DetectPoint detectPoint) throws IOException {
        QueryResult.Series series = this.client.queryForSingleSeries(query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), (Object)series);
        }
        if (series == null) {
            return Collections.emptyList();
        }
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        series.getValues().forEach(values -> {
            Call.CallDetail call = new Call.CallDetail();
            String entityId = String.valueOf(values.get(1));
            int componentId = ((Number)values.get(2)).intValue();
            call.buildFromServiceRelation(entityId, componentId, detectPoint);
            calls.add(call);
        });
        return calls;
    }

    private Query buildQuery(WhereSubQueryImpl<SelectSubQueryImpl<SelectQueryImpl>, SelectQueryImpl> subQuery) {
        SelectQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).column("_entity_id").column("component_id").from(this.client.getDatabase());
        query.setSubQuery((QueryStringBuilder)subQuery.groupBy(new Object[]{"_entity_id"}));
        return query;
    }

    private List<Call.CallDetail> buildInstanceCalls(Query query, DetectPoint detectPoint) throws IOException {
        QueryResult.Series series = this.client.queryForSingleSeries(query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), (Object)series);
        }
        if (series == null) {
            return Collections.emptyList();
        }
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        series.getValues().forEach(values -> {
            Call.CallDetail call = new Call.CallDetail();
            String entityId = (String)values.get(1);
            int componentId = ((Number)values.get(2)).intValue();
            call.buildFromInstanceRelation(entityId, componentId, detectPoint);
            calls.add(call);
        });
        return calls;
    }

    private List<Call.CallDetail> buildEndpointCalls(Query query, DetectPoint detectPoint) throws IOException {
        QueryResult.Series series = this.client.queryForSingleSeries(query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), (Object)series);
        }
        if (series == null) {
            return Collections.emptyList();
        }
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        series.getValues().forEach(values -> {
            Call.CallDetail call = new Call.CallDetail();
            String entityId = (String)values.get(1);
            call.buildFromEndpointRelation(entityId, detectPoint);
            calls.add(call);
        });
        return calls;
    }
}

