/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.healthcheck.DelegatedHealthChecker;
import org.apache.skywalking.oap.server.library.client.healthcheck.HealthCheckable;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.HealthChecker;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxStorageConfig;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.time.TimeInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxClient
implements Client,
HealthCheckable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InfluxClient.class);
    private InfluxStorageConfig config;
    private InfluxDB influx;
    private DelegatedHealthChecker healthChecker = new DelegatedHealthChecker();
    public static final String TIME = "time";
    public static final String TAG_TIME_BUCKET = "_time_bucket";
    private final String database;

    public InfluxClient(InfluxStorageConfig config) {
        this.config = config;
        this.database = config.getDatabase();
    }

    public final String getDatabase() {
        return this.database;
    }

    public void connect() {
        try {
            this.influx = InfluxDBFactory.connect((String)this.config.getUrl(), (String)this.config.getUser(), (String)this.config.getPassword(), (OkHttpClient.Builder)new OkHttpClient.Builder().readTimeout(3L, TimeUnit.MINUTES).writeTimeout(3L, TimeUnit.MINUTES), (InfluxDB.ResponseFormat)InfluxDB.ResponseFormat.MSGPACK);
            this.influx.query(new Query("CREATE DATABASE " + this.database));
            this.influx.enableGzip();
            this.influx.enableBatch(this.config.getActions(), this.config.getDuration(), TimeUnit.MILLISECONDS);
            this.influx.setDatabase(this.database);
            this.healthChecker.health();
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw e;
        }
    }

    private InfluxDB getInflux() {
        return this.influx;
    }

    public List<QueryResult.Result> query(Query query) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("SQL Statement: {}", (Object)query.getCommand());
        }
        try {
            QueryResult result = this.getInflux().query(new Query(query.getCommand()));
            if (result.hasError()) {
                throw new IOException(result.getError());
            }
            this.healthChecker.health();
            return result.getResults();
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw new IOException(e.getMessage() + System.lineSeparator() + "SQL Statement: " + query.getCommand(), e);
        }
    }

    public List<QueryResult.Series> queryForSeries(Query query) throws IOException {
        List<QueryResult.Result> results = this.query(query);
        if (CollectionUtils.isEmpty(results)) {
            return null;
        }
        return results.get(0).getSeries();
    }

    public QueryResult.Series queryForSingleSeries(Query query) throws IOException {
        List<QueryResult.Series> series = this.queryForSeries(query);
        if (CollectionUtils.isEmpty(series)) {
            return null;
        }
        return series.get(0);
    }

    public int getCounter(Query query) throws IOException {
        QueryResult.Series series = this.queryForSingleSeries(query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result: {}", (Object)query.getCommand(), (Object)series);
        }
        if (Objects.isNull(series)) {
            return 0;
        }
        return ((Number)((List)series.getValues().get(0)).get(1)).intValue();
    }

    public void dropSeries(String measurement, long timeBucket) throws IOException {
        Query query = new Query("DROP SERIES FROM " + measurement + " WHERE time_bucket='" + timeBucket + "'");
        this.query(query);
    }

    public void deleteByQuery(String measurement, long timestamp) throws IOException {
        this.query(new Query("delete from " + measurement + " where time < " + timestamp + "ms"));
    }

    public void write(Point point) {
        try {
            this.getInflux().write(point);
            this.healthChecker.health();
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw e;
        }
    }

    public void write(BatchPoints points) {
        try {
            this.getInflux().write(points);
            this.healthChecker.health();
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw e;
        }
    }

    public void shutdown() throws IOException {
        try {
            this.getInflux().close();
            this.healthChecker.health();
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw e;
        }
    }

    public static TimeInterval timeIntervalTS(long timestamp) {
        return BuiltQuery.QueryBuilder.ti((Long)timestamp, (String)"ms");
    }

    public static TimeInterval timeIntervalTB(long timeBucket) {
        return BuiltQuery.QueryBuilder.ti((Long)TimeBucket.getTimestamp((long)timeBucket), (String)"ms");
    }

    public void registerChecker(HealthChecker healthChecker) {
        this.healthChecker.register(healthChecker);
    }
}

