/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.StorageModule;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.core.storage.management.UITemplateManagementDAO;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.util.HealthChecker;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxStorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxTableInstaller;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.base.BatchDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.base.HistoryDeleteDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.base.InfluxStorageDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.AggregationQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.AlarmQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.BrowserLogQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.LogQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.MetadataQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.MetricsQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.NetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.ProfileTaskLogQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.ProfileTaskQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.ProfileThreadSnapshotQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.TopNRecordsQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.TopologyQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.TraceQuery;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.query.UITemplateManagementDAOImpl;
import org.apache.skywalking.oap.server.telemetry.api.HealthCheckMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxStorageProvider
extends ModuleProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InfluxStorageProvider.class);
    private InfluxStorageConfig config = new InfluxStorageConfig();
    private InfluxClient client;

    public String name() {
        return "influxdb";
    }

    public Class<? extends ModuleDefine> module() {
        return StorageModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException {
        this.client = new InfluxClient(this.config);
        this.registerServiceImplementation(IBatchDAO.class, (Service)new BatchDAO(this.client));
        this.registerServiceImplementation(StorageDAO.class, (Service)new InfluxStorageDAO(this.client));
        this.registerServiceImplementation(INetworkAddressAliasDAO.class, (Service)new NetworkAddressAliasDAO(this.client));
        this.registerServiceImplementation(IMetadataQueryDAO.class, (Service)new MetadataQuery(this.client));
        this.registerServiceImplementation(ITopologyQueryDAO.class, (Service)new TopologyQuery(this.client));
        this.registerServiceImplementation(IMetricsQueryDAO.class, (Service)new MetricsQuery(this.client));
        this.registerServiceImplementation(ITraceQueryDAO.class, (Service)new TraceQuery(this.client));
        this.registerServiceImplementation(IBrowserLogQueryDAO.class, (Service)new BrowserLogQuery(this.client));
        this.registerServiceImplementation(IAggregationQueryDAO.class, (Service)new AggregationQuery(this.client));
        this.registerServiceImplementation(IAlarmQueryDAO.class, (Service)new AlarmQuery(this.client));
        this.registerServiceImplementation(ITopNRecordsQueryDAO.class, (Service)new TopNRecordsQuery(this.client));
        this.registerServiceImplementation(ILogQueryDAO.class, (Service)new LogQuery(this.client));
        this.registerServiceImplementation(IProfileTaskQueryDAO.class, (Service)new ProfileTaskQuery(this.client));
        this.registerServiceImplementation(IProfileThreadSnapshotQueryDAO.class, (Service)new ProfileThreadSnapshotQuery(this.client));
        this.registerServiceImplementation(IProfileTaskLogQueryDAO.class, (Service)new ProfileTaskLogQuery(this.client, this.config.getFetchTaskLogMaxSize()));
        this.registerServiceImplementation(IHistoryDeleteDAO.class, (Service)new HistoryDeleteDAO(this.client));
        this.registerServiceImplementation(UITemplateManagementDAO.class, (Service)new UITemplateManagementDAOImpl(this.client));
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        MetricsCreator metricCreator = (MetricsCreator)this.getManager().find("telemetry").provider().getService(MetricsCreator.class);
        HealthCheckMetrics healthChecker = metricCreator.createHealthCheckerGauge("storage_influxdb", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.client.registerChecker((HealthChecker)healthChecker);
        try {
            this.client.connect();
            InfluxTableInstaller installer = new InfluxTableInstaller(this.client, this.getManager());
            ((ModelCreator)this.getManager().find("core").provider().getService(ModelCreator.class)).addModelListener((ModelCreator.CreatingListener)installer);
        }
        catch (StorageException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

