/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.base;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.UpdateRequest;
import org.influxdb.dto.Point;

public class InfluxInsertRequest
implements InsertRequest,
UpdateRequest {
    private Point.Builder builder;
    private Map<String, Object> fields = Maps.newHashMap();

    public InfluxInsertRequest(Model model, StorageData storageData, StorageBuilder storageBuilder) {
        Map objectMap = storageBuilder.data2Map(storageData);
        if ("segment".equals(model.getName())) {
            objectMap.remove("tags");
        }
        for (ModelColumn column : model.getColumns()) {
            Object value = objectMap.get(column.getColumnName().getName());
            if (value instanceof StorageDataComplexObject) {
                this.fields.put(column.getColumnName().getStorageName(), ((StorageDataComplexObject)value).toStorageData());
                continue;
            }
            this.fields.put(column.getColumnName().getStorageName(), value);
        }
        this.builder = Point.measurement((String)model.getName()).addField("id", storageData.id()).fields(this.fields);
    }

    public InfluxInsertRequest time(long time, TimeUnit unit) {
        this.builder.time(time, unit);
        return this;
    }

    public InfluxInsertRequest addFieldAsTag(String fieldName, String tagName) {
        this.builder.tag(tagName, String.valueOf(this.fields.get(fieldName)));
        return this;
    }

    public InfluxInsertRequest tag(String key, String value) {
        this.builder.tag(key, value);
        return this;
    }

    public Point getPoint() {
        return this.builder.build();
    }
}

