/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.SelectedRecord;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.QueryStringBuilder;
import org.influxdb.querybuilder.SelectQueryImpl;
import org.influxdb.querybuilder.SelectSubQueryImpl;
import org.influxdb.querybuilder.WhereSubQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationQuery
implements IAggregationQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AggregationQuery.class);
    private InfluxClient client;
    private static final Comparator<SelectedRecord> ASCENDING = (a, b) -> Long.compare(Long.parseLong(a.getValue()), Long.parseLong(b.getValue()));
    private static final Comparator<SelectedRecord> DESCENDING = (a, b) -> Long.compare(Long.parseLong(b.getValue()), Long.parseLong(a.getValue()));

    public AggregationQuery(InfluxClient client) {
        this.client = client;
    }

    public List<SelectedRecord> sortMetrics(TopNCondition condition, String valueColumnName, Duration duration, List<KeyValue> additionalConditions) throws IOException {
        String measurement = condition.getName();
        Comparator<SelectedRecord> comparator = DESCENDING;
        String functionName = "top";
        if (condition.getOrder().equals((Object)Order.ASC)) {
            functionName = "bottom";
            comparator = ASCENDING;
        }
        SelectQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).function(functionName, new Object[]{"mean", condition.getTopN()}).as("value").column("_entity_id").from(this.client.getDatabase(), measurement);
        WhereSubQueryImpl where = BuiltQuery.QueryBuilder.select((String[])new String[0]).fromSubQuery(this.client.getDatabase()).mean((Object)valueColumnName).from(condition.getName()).where();
        if (additionalConditions != null) {
            additionalConditions.forEach(moreCondition -> where.and(BuiltQuery.QueryBuilder.eq((String)moreCondition.getKey(), (Object)moreCondition.getValue())));
        }
        SelectSubQueryImpl subQuery = (SelectSubQueryImpl)where.and(BuiltQuery.QueryBuilder.gte((String)"time", (Object)InfluxClient.timeIntervalTS(duration.getStartTimestamp()))).and(BuiltQuery.QueryBuilder.lte((String)"time", (Object)InfluxClient.timeIntervalTS(duration.getEndTimestamp()))).groupBy(new Object[]{"_entity_id"});
        query.setSubQuery((QueryStringBuilder)subQuery);
        List<QueryResult.Series> series = this.client.queryForSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), series);
        }
        if (series == null || series.isEmpty()) {
            return Collections.emptyList();
        }
        List dataset = series.get(0).getValues();
        ArrayList entities = Lists.newArrayListWithCapacity((int)dataset.size());
        dataset.forEach(values -> {
            SelectedRecord entity = new SelectedRecord();
            entity.setId((String)values.get(2));
            entity.setValue(((Double)values.get(1)).longValue() + "");
            entities.add(entity);
        });
        Collections.sort(entities, comparator);
        return entities;
    }
}

