/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.query.type.ContentType;
import org.apache.skywalking.oap.server.core.query.type.Log;
import org.apache.skywalking.oap.server.core.query.type.LogState;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.core.query.type.Pagination;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.elasticsearch.common.Strings;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.SelectQueryImpl;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.influxdb.querybuilder.clauses.Clause;
import org.influxdb.querybuilder.clauses.ConjunctionClause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogQuery
implements ILogQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogQuery.class);
    private final InfluxClient client;

    public LogQuery(InfluxClient client) {
        this.client = client;
    }

    public Logs queryLogs(String metricName, int serviceId, int serviceInstanceId, String endpointId, String traceId, LogState state, String stateCode, Pagination paging, int from, int limit, long startTB, long endTB) throws IOException {
        WhereQueryImpl recallQuery = BuiltQuery.QueryBuilder.select((String[])new String[0]).raw("*::field").from(this.client.getDatabase(), metricName).where();
        if (serviceId != 0) {
            recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"_service_id", (Object)String.valueOf(serviceId)));
        }
        if (serviceInstanceId != 0) {
            recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"service_instance_id", (Object)serviceInstanceId));
        }
        if (StringUtil.isNotEmpty((String)endpointId)) {
            recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"endpoint_id", (Object)endpointId));
        }
        if (!Strings.isNullOrEmpty((String)traceId)) {
            recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"trace_id", (Object)traceId));
        }
        switch (state) {
            case ERROR: {
                recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"is_error", (Object)true));
                break;
            }
            case SUCCESS: {
                recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"is_error", (Object)false));
            }
        }
        if (!Strings.isNullOrEmpty((String)stateCode)) {
            recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"status_code", (Object)stateCode));
        }
        recallQuery.and(BuiltQuery.QueryBuilder.gte((String)"time_bucket", (Object)startTB)).and(BuiltQuery.QueryBuilder.lte((String)"time_bucket", (Object)endTB));
        if (from > 0) {
            recallQuery.limit(limit, (long)from);
        } else {
            recallQuery.limit(limit);
        }
        SelectQueryImpl countQuery = BuiltQuery.QueryBuilder.select((String[])new String[0]).count((Object)"endpoint_id").from(this.client.getDatabase(), metricName);
        for (ConjunctionClause clause : recallQuery.getClauses()) {
            countQuery.where((Clause)clause);
        }
        Query query = new Query(countQuery.getCommand() + recallQuery.getCommand());
        List<QueryResult.Result> results = this.client.query(query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} \nresult set: {}", (Object)query.getCommand(), results);
        }
        if (results.size() != 2) {
            throw new IOException("Expecting to get 2 Results, but it is " + results.size());
        }
        Logs logs = new Logs();
        QueryResult.Result counter = results.get(0);
        QueryResult.Result seriesList = results.get(1);
        logs.setTotal(((Number)((List)((QueryResult.Series)counter.getSeries().get(0)).getValues().get(0)).get(1)).intValue());
        seriesList.getSeries().forEach(series -> {
            List columns = series.getColumns();
            series.getValues().forEach(values -> {
                HashMap data = Maps.newHashMap();
                Log log = new Log();
                for (int i = 1; i < columns.size(); ++i) {
                    Object value = values.get(i);
                    if (value instanceof StorageDataComplexObject) {
                        value = ((StorageDataComplexObject)value).toStorageData();
                    }
                    data.put(columns.get(i), value);
                }
                log.setContent((String)data.get("content"));
                log.setContentType(ContentType.instanceOf((int)((Number)data.get("content_type")).intValue()));
                log.setEndpointId((String)data.get("endpoint_id"));
                log.setEndpointName((String)data.get("endpoint_name"));
                log.setTraceId((String)data.get("trace_id"));
                log.setTimestamp((String)data.get("timestamp"));
                log.setStatusCode((String)data.get("status_code"));
                log.setServiceId((String)data.get("service_id"));
                log.setServiceInstanceId((String)data.get("service_instance_id"));
                logs.getLogs().add(log);
            });
        });
        return logs;
    }
}

