/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.profile.ProfileThreadSnapshotRecord;
import org.apache.skywalking.oap.server.core.query.type.BasicTrace;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.elasticsearch.common.Strings;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileThreadSnapshotQuery
implements IProfileThreadSnapshotQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileThreadSnapshotQuery.class);
    private final InfluxClient client;

    public ProfileThreadSnapshotQuery(InfluxClient client) {
        this.client = client;
    }

    public List<BasicTrace> queryProfiledSegments(String taskId) throws IOException {
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[]{"segment_id"}).from(this.client.getDatabase(), "profile_task_segment_snapshot").where().and(BuiltQuery.QueryBuilder.eq((String)"task_id", (Object)taskId)).and(BuiltQuery.QueryBuilder.eq((String)"sequence", (Object)0));
        LinkedList segments = new LinkedList();
        QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
        if (Objects.isNull(series)) {
            return Collections.emptyList();
        }
        series.getValues().forEach(values -> segments.add((String)values.get(1)));
        if (segments.isEmpty()) {
            return Collections.emptyList();
        }
        query = BuiltQuery.QueryBuilder.select((String[])new String[0]).function("bottom", new Object[]{"start_time", segments.size()}).column("segment_id").column("start_time").column("endpoint_name").column("latency").column("is_error").column("trace_id").from(this.client.getDatabase(), "segment").where().and(BuiltQuery.QueryBuilder.contains((String)"segment_id", (String)Joiner.on((String)"|").join(segments)));
        ArrayList result = Lists.newArrayListWithCapacity((int)segments.size());
        this.client.queryForSingleSeries((Query)query).getValues().stream().sorted((a, b) -> Long.compare(((Number)b.get(1)).longValue(), ((Number)a.get(1)).longValue())).forEach(values -> {
            BasicTrace basicTrace = new BasicTrace();
            basicTrace.setSegmentId((String)values.get(2));
            basicTrace.setStart(String.valueOf(values.get(3)));
            basicTrace.getEndpointNames().add((String)values.get(4));
            basicTrace.setDuration(((Number)values.get(5)).intValue());
            basicTrace.setError(BooleanUtils.valueToBoolean((int)((Number)values.get(6)).intValue()));
            String traceIds = (String)values.get(7);
            basicTrace.getTraceIds().add(traceIds);
            result.add(basicTrace);
        });
        return result;
    }

    public int queryMinSequence(String segmentId, long start, long end) throws IOException {
        return this.querySequenceWithAgg("min", segmentId, start, end);
    }

    public int queryMaxSequence(String segmentId, long start, long end) throws IOException {
        return this.querySequenceWithAgg("max", segmentId, start, end);
    }

    public List<ProfileThreadSnapshotRecord> queryRecords(String segmentId, int minSequence, int maxSequence) throws IOException {
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[]{"task_id", "segment_id", "dump_time", "sequence", "stack_binary"}).from(this.client.getDatabase(), "profile_task_segment_snapshot").where(BuiltQuery.QueryBuilder.eq((String)"segment_id", (Object)segmentId)).and(BuiltQuery.QueryBuilder.gte((String)"sequence", (Object)minSequence)).and(BuiltQuery.QueryBuilder.lte((String)"sequence", (Object)maxSequence));
        QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result: {}", (Object)query.getCommand(), (Object)series);
        }
        if (Objects.isNull(series)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ProfileThreadSnapshotRecord> result = new ArrayList<ProfileThreadSnapshotRecord>(maxSequence - minSequence);
        series.getValues().forEach(values -> {
            ProfileThreadSnapshotRecord record = new ProfileThreadSnapshotRecord();
            record.setTaskId((String)values.get(1));
            record.setSegmentId((String)values.get(2));
            record.setDumpTime(((Number)values.get(3)).longValue());
            record.setSequence(((Number)values.get(4)).intValue());
            String dataBinaryBase64 = String.valueOf(values.get(5));
            if (StringUtil.isNotEmpty((String)dataBinaryBase64)) {
                record.setStackBinary(Base64.getDecoder().decode(dataBinaryBase64));
            }
            result.add(record);
        });
        return result;
    }

    public SegmentRecord getProfiledSegment(String segmentId) throws IOException {
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).column("segment_id").column("trace_id").column("service_id").column("endpoint_name").column("start_time").column("end_time").column("latency").column("is_error").column("data_binary").column("version").from(this.client.getDatabase(), "segment").where().and(BuiltQuery.QueryBuilder.eq((String)"segment_id", (Object)segmentId));
        List<QueryResult.Series> series = this.client.queryForSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), series);
        }
        if (Objects.isNull(series) || series.isEmpty()) {
            return null;
        }
        List values = (List)series.get(0).getValues().get(0);
        SegmentRecord segmentRecord = new SegmentRecord();
        segmentRecord.setSegmentId((String)values.get(1));
        segmentRecord.setTraceId((String)values.get(2));
        segmentRecord.setServiceId((String)values.get(3));
        segmentRecord.setEndpointName((String)values.get(4));
        segmentRecord.setStartTime(((Long)values.get(5)).longValue());
        segmentRecord.setEndTime(((Long)values.get(6)).longValue());
        segmentRecord.setLatency(((Integer)values.get(7)).intValue());
        segmentRecord.setIsError(((Integer)values.get(8)).intValue());
        segmentRecord.setVersion(((Integer)values.get(10)).intValue());
        String base64 = (String)values.get(9);
        if (!Strings.isNullOrEmpty((String)base64)) {
            segmentRecord.setDataBinary(Base64.getDecoder().decode(base64));
        }
        return segmentRecord;
    }

    private int querySequenceWithAgg(String function, String segmentId, long start, long end) throws IOException {
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).function(function, new Object[]{"sequence"}).from(this.client.getDatabase(), "profile_task_segment_snapshot").where().and(BuiltQuery.QueryBuilder.eq((String)"segment_id", (Object)segmentId)).and(BuiltQuery.QueryBuilder.gte((String)"dump_time", (Object)start)).and(BuiltQuery.QueryBuilder.lte((String)"dump_time", (Object)end));
        return this.client.getCounter((Query)query);
    }
}

