/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SpanTag;
import org.apache.skywalking.oap.server.core.query.type.BasicTrace;
import org.apache.skywalking.oap.server.core.query.type.QueryOrder;
import org.apache.skywalking.oap.server.core.query.type.Span;
import org.apache.skywalking.oap.server.core.query.type.TraceBrief;
import org.apache.skywalking.oap.server.core.query.type.TraceState;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.WhereNested;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.influxdb.querybuilder.clauses.Clause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceQuery
implements ITraceQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TraceQuery.class);
    private final InfluxClient client;

    public TraceQuery(InfluxClient client) {
        this.client = client;
    }

    public TraceBrief queryBasicTraces(long startSecondTB, long endSecondTB, long minDuration, long maxDuration, String endpointName, String serviceId, String serviceInstanceId, String endpointId, String traceId, int limit, int from, TraceState traceState, QueryOrder queryOrder, List<SpanTag> tags) throws IOException {
        String orderBy = "start_time";
        if (queryOrder == QueryOrder.BY_DURATION) {
            orderBy = "latency";
        }
        WhereQueryImpl recallQuery = BuiltQuery.QueryBuilder.select((String[])new String[0]).function("top", new Object[]{orderBy, limit + from}).column("segment_id").column("start_time").column("endpoint_name").column("latency").column("is_error").column("trace_id").from(this.client.getDatabase(), "segment").where();
        if (startSecondTB != 0L && endSecondTB != 0L) {
            recallQuery.and(BuiltQuery.QueryBuilder.gte((String)"time_bucket", (Object)startSecondTB)).and(BuiltQuery.QueryBuilder.lte((String)"time_bucket", (Object)endSecondTB));
        }
        if (minDuration != 0L) {
            recallQuery.and(BuiltQuery.QueryBuilder.gte((String)"latency", (Object)minDuration));
        }
        if (maxDuration != 0L) {
            recallQuery.and(BuiltQuery.QueryBuilder.lte((String)"latency", (Object)maxDuration));
        }
        if (!org.elasticsearch.common.Strings.isNullOrEmpty((String)endpointName)) {
            recallQuery.and(BuiltQuery.QueryBuilder.contains((String)"endpoint_name", (String)endpointName.replaceAll("/", "\\\\/")));
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"_service_id", (Object)serviceId));
        }
        if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
            recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"service_instance_id", (Object)serviceInstanceId));
        }
        if (!Strings.isNullOrEmpty((String)endpointId)) {
            recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"endpoint_id", (Object)endpointId));
        }
        if (!org.elasticsearch.common.Strings.isNullOrEmpty((String)traceId)) {
            recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"trace_id", (Object)traceId));
        }
        switch (traceState) {
            case ERROR: {
                recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"is_error", (Object)1));
                break;
            }
            case SUCCESS: {
                recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"is_error", (Object)0));
            }
        }
        if (CollectionUtils.isNotEmpty(tags)) {
            WhereNested nested = recallQuery.andNested();
            for (SpanTag tag : tags) {
                nested.and(BuiltQuery.QueryBuilder.contains((String)tag.getKey(), (String)("'" + tag.getValue() + "'")));
            }
            nested.close();
        }
        WhereQueryImpl countQuery = BuiltQuery.QueryBuilder.select((String[])new String[0]).count((Object)"endpoint_id").from(this.client.getDatabase(), "segment").where();
        for (Clause clause : recallQuery.getClauses()) {
            countQuery.where(clause);
        }
        Query query = new Query(countQuery.getCommand() + recallQuery.getCommand());
        List<QueryResult.Result> results = this.client.query(query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), results);
        }
        if (results.size() != 2) {
            throw new IOException("Expecting to get 2 Results, but it is " + results.size());
        }
        List counter = results.get(0).getSeries();
        List result = results.get(1).getSeries();
        if (result == null || result.isEmpty()) {
            return new TraceBrief();
        }
        TraceBrief traceBrief = new TraceBrief();
        traceBrief.setTotal(((Number)((List)((QueryResult.Series)counter.get(0)).getValues().get(0)).get(1)).intValue());
        ((QueryResult.Series)result.get(0)).getValues().stream().sorted((a, b) -> Long.compare(((Number)b.get(1)).longValue(), ((Number)a.get(1)).longValue())).skip(from).forEach(values -> {
            BasicTrace basicTrace = new BasicTrace();
            basicTrace.setSegmentId((String)values.get(2));
            basicTrace.setStart(String.valueOf(values.get(3)));
            basicTrace.getEndpointNames().add((String)values.get(4));
            basicTrace.setDuration(((Number)values.get(5)).intValue());
            basicTrace.setError(BooleanUtils.valueToBoolean((int)((Number)values.get(6)).intValue()));
            basicTrace.getTraceIds().add((String)values.get(7));
            traceBrief.getTraces().add(basicTrace);
        });
        return traceBrief;
    }

    public List<SegmentRecord> queryByTraceId(String traceId) throws IOException {
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).column("segment_id").column("trace_id").column("service_id").column("service_instance_id").column("endpoint_name").column("start_time").column("end_time").column("latency").column("is_error").column("data_binary").column("version").from(this.client.getDatabase(), "segment").where().and(BuiltQuery.QueryBuilder.eq((String)"trace_id", (Object)traceId));
        List<QueryResult.Series> series = this.client.queryForSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), series);
        }
        if (series == null || series.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList segmentRecords = Lists.newArrayList();
        series.get(0).getValues().forEach(values -> {
            SegmentRecord segmentRecord = new SegmentRecord();
            segmentRecord.setSegmentId((String)values.get(1));
            segmentRecord.setTraceId((String)values.get(2));
            segmentRecord.setServiceId((String)values.get(3));
            segmentRecord.setServiceInstanceId((String)values.get(4));
            segmentRecord.setEndpointName((String)values.get(5));
            segmentRecord.setStartTime(((Number)values.get(6)).longValue());
            segmentRecord.setEndTime(((Number)values.get(7)).longValue());
            segmentRecord.setLatency(((Number)values.get(8)).intValue());
            segmentRecord.setIsError(((Number)values.get(9)).intValue());
            segmentRecord.setVersion(((Number)values.get(11)).intValue());
            String base64 = (String)values.get(10);
            if (!org.elasticsearch.common.Strings.isNullOrEmpty((String)base64)) {
                segmentRecord.setDataBinary(Base64.getDecoder().decode(base64));
            }
            segmentRecords.add(segmentRecord);
        });
        return segmentRecords;
    }

    public List<Span> doFlexibleTraceQuery(String traceId) throws IOException {
        return Collections.emptyList();
    }
}

