/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.base;

import java.io.IOException;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryDeleteDAO
implements IHistoryDeleteDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HistoryDeleteDAO.class);
    private final InfluxClient client;

    public HistoryDeleteDAO(InfluxClient client) {
        this.client = client;
    }

    public void deleteHistory(Model model, String timeBucketColumnName, int ttl) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("TTL execution log, model: {}", (Object)model.getName());
        }
        try {
            long deadline = Long.parseLong(new DateTime().plusDays(-ttl).toString("yyyyMMddHHmm"));
            this.client.deleteByQuery(model.getName(), TimeBucket.getTimestamp((long)deadline));
        }
        catch (Exception e) {
            log.error("TTL execution log, model: {}, errMsg: {}", (Object)model.getName(), (Object)e.getMessage());
        }
    }
}

