/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.base;

import org.apache.skywalking.oap.server.core.analysis.config.NoneStream;
import org.apache.skywalking.oap.server.core.analysis.management.ManagementData;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.storage.IManagementDAO;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.INoneStreamDAO;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.base.ManagementDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.base.MetricsDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.base.NoneStreamDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.base.RecordDAO;

public class InfluxStorageDAO
implements StorageDAO {
    private final InfluxClient influxClient;

    public InfluxStorageDAO(InfluxClient influxClient) {
        this.influxClient = influxClient;
    }

    public IMetricsDAO newMetricsDao(StorageBuilder<Metrics> storageBuilder) {
        return new MetricsDAO(this.influxClient, storageBuilder);
    }

    public IRecordDAO newRecordDao(StorageBuilder<Record> storageBuilder) {
        return new RecordDAO(storageBuilder);
    }

    public INoneStreamDAO newNoneStreamDao(StorageBuilder<NoneStream> storageBuilder) {
        return new NoneStreamDAO(this.influxClient, storageBuilder);
    }

    public IManagementDAO newManagementDao(StorageBuilder<ManagementData> storageBuilder) {
        return new ManagementDAO(this.influxClient, storageBuilder);
    }
}

