/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.base;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.management.ManagementData;
import org.apache.skywalking.oap.server.core.storage.IManagementDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Point;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementDAO
implements IManagementDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManagementDAO.class);
    private final InfluxClient client;
    private final StorageBuilder<ManagementData> storageBuilder;

    public ManagementDAO(InfluxClient client, StorageBuilder<ManagementData> storageBuilder) {
        this.client = client;
        this.storageBuilder = storageBuilder;
    }

    public void insert(Model model, ManagementData managementData) throws IOException {
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).column("id").column("\"name\"").from(this.client.getDatabase(), "ui_template").where(BuiltQuery.QueryBuilder.eq((String)"id", (Object)managementData.id()));
        QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result: {}", (Object)query.getCommand(), (Object)series);
        }
        if (series != null && series.getValues().size() > 0) {
            return;
        }
        Point point = Point.measurement((String)"ui_template").tag("_id", managementData.id()).time(1L, TimeUnit.NANOSECONDS).fields(this.storageBuilder.data2Map((StorageData)managementData)).build();
        this.client.write(point);
    }
}

