/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.base;

import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.commons.datacarrier.common.AtomicRangeInteger;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.config.NoneStream;
import org.apache.skywalking.oap.server.core.storage.INoneStreamDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.TableMetaInfo;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.base.InfluxInsertRequest;

public class NoneStreamDAO
implements INoneStreamDAO {
    private static final int PADDING_SIZE = 1000000;
    private static final AtomicRangeInteger SUFFIX = new AtomicRangeInteger(0, 1000000);
    private final InfluxClient client;
    private final StorageBuilder<NoneStream> storageBuilder;

    public NoneStreamDAO(InfluxClient client, StorageBuilder<NoneStream> storageBuilder) {
        this.client = client;
        this.storageBuilder = storageBuilder;
    }

    public void insert(Model model, NoneStream noneStream) {
        long timestamp = TimeBucket.getTimestamp((long)noneStream.getTimeBucket(), (DownSampling)model.getDownsampling()) * 1000000L + (long)SUFFIX.getAndIncrement();
        InfluxInsertRequest request = new InfluxInsertRequest(model, noneStream, this.storageBuilder).time(timestamp, TimeUnit.NANOSECONDS);
        TableMetaInfo.get(model.getName()).getStorageAndTagMap().forEach(request::addFieldAsTag);
        this.client.write(request.getPoint());
    }
}

