/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.event.Event;
import org.apache.skywalking.oap.server.core.query.type.event.EventQueryCondition;
import org.apache.skywalking.oap.server.core.query.type.event.EventType;
import org.apache.skywalking.oap.server.core.query.type.event.Events;
import org.apache.skywalking.oap.server.core.query.type.event.Source;
import org.apache.skywalking.oap.server.core.storage.query.IEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.SelectQueryImpl;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventQueryDAO
implements IEventQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventQueryDAO.class);
    private final InfluxClient client;

    public Events queryEvents(EventQueryCondition condition) throws Exception {
        WhereQueryImpl<SelectQueryImpl> recallQuery = this.buildQuery(condition);
        SelectQueryImpl countQuery = BuiltQuery.QueryBuilder.select((String[])new String[0]).count((Object)"uuid").from(this.client.getDatabase(), "events");
        recallQuery.getClauses().forEach(arg_0 -> ((SelectQueryImpl)countQuery).where(arg_0));
        Query query = new Query(countQuery.getCommand() + recallQuery.getCommand());
        List<QueryResult.Result> results = this.client.query(query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {}", (Object)query.getCommand());
            log.debug("Result: {}", results);
        }
        if (results.size() != 2) {
            throw new IOException("Expecting to get 2 Results, but it is " + results.size());
        }
        QueryResult.Series counterSeries = (QueryResult.Series)results.get(0).getSeries().get(0);
        List recallSeries = results.get(1).getSeries();
        Events events = new Events();
        events.setTotal(((Number)((List)counterSeries.getValues().get(0)).get(1)).longValue());
        recallSeries.forEach(series -> series.getValues().forEach(values -> events.getEvents().add(this.parseSeriesValues((QueryResult.Series)series, (List<Object>)values))));
        return events;
    }

    protected Event parseSeriesValues(QueryResult.Series series, List<Object> values) {
        Event event = new Event();
        List columns = series.getColumns();
        HashMap data = new HashMap();
        for (int i = 1; i < columns.size(); ++i) {
            Object value = values.get(i);
            if (value instanceof StorageDataComplexObject) {
                value = ((StorageDataComplexObject)value).toStorageData();
            }
            data.put(columns.get(i), value);
        }
        event.setUuid((String)data.get("uuid"));
        String service = (String)data.get("service");
        String serviceInstance = (String)data.get("service_instance");
        String endpoint = (String)data.get("endpoint");
        event.setSource(new Source(service, serviceInstance, endpoint));
        event.setName((String)data.get("name"));
        event.setType(EventType.parse((String)((String)data.get("type"))));
        event.setMessage((String)data.get("message"));
        event.setParameters((String)data.get("parameters"));
        event.setStartTime(((Number)data.get("start_time")).longValue());
        event.setEndTime(((Number)data.get("end_time")).longValue());
        return event;
    }

    protected WhereQueryImpl<SelectQueryImpl> buildQuery(EventQueryCondition condition) {
        Duration startTime;
        Source source;
        String topFunc = Order.DES.equals((Object)condition.getOrder()) ? "top" : "bottom";
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).raw("*::field").function(topFunc, new Object[]{"start_time", condition.getSize()}).from(this.client.getDatabase(), "events").where();
        if (!Strings.isNullOrEmpty((String)condition.getUuid())) {
            query.and(BuiltQuery.QueryBuilder.eq((String)"uuid", (Object)condition.getUuid()));
        }
        if ((source = condition.getSource()) != null) {
            if (!Strings.isNullOrEmpty((String)source.getService())) {
                query.and(BuiltQuery.QueryBuilder.eq((String)"service", (Object)source.getService()));
            }
            if (!Strings.isNullOrEmpty((String)source.getServiceInstance())) {
                query.and(BuiltQuery.QueryBuilder.eq((String)"service_instance", (Object)source.getServiceInstance()));
            }
            if (!Strings.isNullOrEmpty((String)source.getEndpoint())) {
                query.and(BuiltQuery.QueryBuilder.contains((String)"endpoint", (String)source.getEndpoint().replaceAll("/", "\\\\/")));
            }
        }
        if (!Strings.isNullOrEmpty((String)condition.getName())) {
            query.and(BuiltQuery.QueryBuilder.eq((String)"\"name\"", (Object)condition.getName()));
        }
        if (condition.getType() != null) {
            query.and(BuiltQuery.QueryBuilder.eq((String)"type", (Object)condition.getType().name()));
        }
        if ((startTime = condition.getTime()) != null) {
            if (startTime.getStartTimestamp() > 0L) {
                query.and(BuiltQuery.QueryBuilder.gt((String)"start_time", (Object)startTime.getStartTimestamp()));
            }
            if (startTime.getEndTimestamp() > 0L) {
                query.and(BuiltQuery.QueryBuilder.lt((String)"end_time", (Object)startTime.getEndTimestamp()));
            }
        }
        return query;
    }

    @Generated
    public EventQueryDAO(InfluxClient client) {
        this.client = client;
    }
}

