/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.type.ProfileTaskLog;
import org.apache.skywalking.oap.server.core.query.type.ProfileTaskLogOperationType;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileTaskLogQuery
implements IProfileTaskLogQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileTaskLogQuery.class);
    private final InfluxClient client;
    private final int fetchTaskLogMaxSize;

    public ProfileTaskLogQuery(InfluxClient client, int fetchTaskLogMaxSize) {
        this.client = client;
        this.fetchTaskLogMaxSize = fetchTaskLogMaxSize;
    }

    public List<ProfileTaskLog> getTaskLogList() throws IOException {
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).function("top", new Object[]{"operation_time", this.fetchTaskLogMaxSize}).column("id").column("task_id").column("instance_id").column("operation_time").column("operation_type").from(this.client.getDatabase(), "profile_task_log").where();
        QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), (Object)series);
        }
        if (series == null) {
            return Collections.emptyList();
        }
        ArrayList taskLogs = Lists.newArrayList();
        series.getValues().stream().sorted((a, b) -> Long.compare(((Number)b.get(1)).longValue(), ((Number)a.get(1)).longValue())).forEach(values -> taskLogs.add(ProfileTaskLog.builder().id((String)values.get(2)).taskId((String)values.get(3)).instanceId((String)values.get(4)).operationTime(((Number)values.get(5)).longValue()).operationType(ProfileTaskLogOperationType.parse((int)((Number)values.get(6)).intValue())).build()));
        return taskLogs;
    }
}

