/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.management.ui.template.UITemplate;
import org.apache.skywalking.oap.server.core.query.input.DashboardSetting;
import org.apache.skywalking.oap.server.core.query.type.DashboardConfiguration;
import org.apache.skywalking.oap.server.core.query.type.TemplateChangeStatus;
import org.apache.skywalking.oap.server.core.storage.management.UITemplateManagementDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Point;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UITemplateManagementDAOImpl
implements UITemplateManagementDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UITemplateManagementDAOImpl.class);
    private final InfluxClient client;

    public List<DashboardConfiguration> getAllTemplates(Boolean includingDisabled) throws IOException {
        WhereQueryImpl where = BuiltQuery.QueryBuilder.select((String[])new String[0]).raw("*::field").from(this.client.getDatabase(), "ui_template").where();
        if (!includingDisabled.booleanValue()) {
            where.and(BuiltQuery.QueryBuilder.eq((String)"disabled", (Object)0));
        }
        QueryResult.Series series = this.client.queryForSingleSeries((Query)where);
        ArrayList<DashboardConfiguration> configs = new ArrayList<DashboardConfiguration>();
        UITemplate.Builder builder = new UITemplate.Builder();
        if (Objects.nonNull(series)) {
            List columnNames = series.getColumns();
            int size = series.getValues().size();
            for (int offset = 0; offset < size; ++offset) {
                List columnValues = (List)series.getValues().get(offset);
                HashMap data = Maps.newHashMap();
                for (int i = 1; i < columnNames.size(); ++i) {
                    data.put(columnNames.get(i), columnValues.get(i));
                }
                UITemplate uiTemplate = builder.storage2Entity((Map)data);
                configs.add(new DashboardConfiguration().fromEntity(uiTemplate));
            }
        }
        return configs;
    }

    public TemplateChangeStatus addTemplate(DashboardSetting setting) {
        UITemplate.Builder builder = new UITemplate.Builder();
        UITemplate uiTemplate = setting.toEntity();
        Point point = Point.measurement((String)"ui_template").tag("_id", uiTemplate.id()).fields(builder.entity2Storage(uiTemplate)).time(1L, TimeUnit.NANOSECONDS).build();
        this.client.write(point);
        return TemplateChangeStatus.builder().status(true).build();
    }

    public TemplateChangeStatus changeTemplate(DashboardSetting setting) throws IOException {
        UITemplate.Builder builder = new UITemplate.Builder();
        UITemplate uiTemplate = setting.toEntity();
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).all().from(this.client.getDatabase(), "ui_template").where(BuiltQuery.QueryBuilder.eq((String)"_id", (Object)uiTemplate.id()));
        QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
        if (Objects.nonNull(series)) {
            Point point = Point.measurement((String)"ui_template").fields(builder.entity2Storage(uiTemplate)).tag("_id", uiTemplate.id()).time(1L, TimeUnit.NANOSECONDS).build();
            this.client.write(point);
            return TemplateChangeStatus.builder().status(true).build();
        }
        return TemplateChangeStatus.builder().status(false).message("Can't find the template").build();
    }

    public TemplateChangeStatus disableTemplate(String name) throws IOException {
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).all().from(this.client.getDatabase(), "ui_template").where(BuiltQuery.QueryBuilder.eq((String)"_id", (Object)name));
        QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
        if (Objects.nonNull(series)) {
            Point point = Point.measurement((String)"ui_template").tag("_id", name).addField("disabled", 1L).time(1L, TimeUnit.NANOSECONDS).build();
            this.client.write(point);
            return TemplateChangeStatus.builder().status(true).build();
        }
        return TemplateChangeStatus.builder().status(false).message("Can't find the template").build();
    }

    @Generated
    public UITemplateManagementDAOImpl(InfluxClient client) {
        this.client = client;
    }
}

