/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.browser.source.BrowserErrorCategory;
import org.apache.skywalking.oap.server.core.query.type.BrowserErrorLog;
import org.apache.skywalking.oap.server.core.query.type.BrowserErrorLogs;
import org.apache.skywalking.oap.server.core.storage.query.IBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserLogQuery
implements IBrowserLogQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BrowserLogQuery.class);
    private final InfluxClient client;

    public BrowserErrorLogs queryBrowserErrorLogs(String serviceId, String serviceVersionId, String pagePathId, String pagePath, BrowserErrorCategory category, long startSecondTB, long endSecondTB, int limit, int from) throws IOException {
        WhereQueryImpl recallQuery = BuiltQuery.QueryBuilder.select((String[])new String[0]).function("top", new Object[]{"timestamp", limit + from}).column("data_binary").from(this.client.getDatabase(), "browser_error_log").where();
        if (startSecondTB != 0L && endSecondTB != 0L) {
            recallQuery.and(BuiltQuery.QueryBuilder.gte((String)"time_bucket", (Object)startSecondTB)).and(BuiltQuery.QueryBuilder.lte((String)"time_bucket", (Object)endSecondTB));
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"service_id", (Object)serviceId));
        }
        if (StringUtil.isNotEmpty((String)serviceVersionId)) {
            recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"service_version_id", (Object)serviceVersionId));
        }
        if (StringUtil.isNotEmpty((String)pagePathId)) {
            recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"pate_path_id", (Object)pagePathId));
        }
        if (Objects.nonNull(category)) {
            recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"error_category", (Object)category.getValue()));
        }
        if (StringUtil.isNotEmpty((String)pagePath)) {
            recallQuery.and(BuiltQuery.QueryBuilder.contains((String)"page_path", (String)pagePath.replaceAll("/", "\\\\/")));
        }
        WhereQueryImpl countQuery = BuiltQuery.QueryBuilder.select((String[])new String[0]).count((Object)"service_id").from(this.client.getDatabase(), "browser_error_log").where();
        recallQuery.getClauses().forEach(arg_0 -> ((WhereQueryImpl)countQuery).where(arg_0));
        Query query = new Query(countQuery.getCommand() + recallQuery.getCommand());
        List<QueryResult.Result> results = this.client.query(query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), results);
        }
        if (results.size() != 2) {
            throw new IOException("Expecting to get 2 Results, but it is " + results.size());
        }
        List counter = results.get(0).getSeries();
        List result = results.get(1).getSeries();
        if (result == null || result.isEmpty()) {
            return new BrowserErrorLogs();
        }
        BrowserErrorLogs logs = new BrowserErrorLogs();
        logs.setTotal(((Number)((List)((QueryResult.Series)counter.get(0)).getValues().get(0)).get(1)).intValue());
        ((QueryResult.Series)result.get(0)).getValues().stream().sorted((a, b) -> Long.compare(((Number)b.get(1)).longValue(), ((Number)a.get(1)).longValue())).skip(from).forEach(values -> {
            String dataBinaryBase64 = (String)values.get(2);
            if (Objects.nonNull(dataBinaryBase64)) {
                BrowserErrorLog log = this.parserDataBinary(dataBinaryBase64);
                logs.getLogs().add(log);
            }
        });
        return logs;
    }

    @Generated
    public BrowserLogQuery(InfluxClient client) {
        this.client = client;
    }
}

