/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.base;

import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.PrepareRequest;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.base.InfluxInsertRequest;
import org.influxdb.dto.BatchPoints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchDAO
implements IBatchDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchDAO.class);
    private final InfluxClient client;

    public BatchDAO(InfluxClient client) {
        this.client = client;
    }

    public void insert(InsertRequest insertRequest) {
        this.client.write(((InfluxInsertRequest)insertRequest).getPoint());
    }

    public void flush(List<PrepareRequest> prepareRequests) {
        if (CollectionUtils.isEmpty(prepareRequests)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("batch sql statements execute, data size: {}", (Object)prepareRequests.size());
        }
        BatchPoints.Builder builder = BatchPoints.builder();
        prepareRequests.forEach(e -> builder.point(((InfluxInsertRequest)e).getPoint()));
        this.client.write(builder.build());
    }
}

