/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.base;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.commons.datacarrier.common.AtomicRangeInteger;
import org.apache.skywalking.oap.server.core.alarm.AlarmRecord;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.log.LogRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.StorageHashMapBuilder;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.TableMetaInfo;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.base.InfluxInsertRequest;

public class RecordDAO
implements IRecordDAO {
    private static final int PADDING_SIZE = 1000000;
    private static final AtomicRangeInteger SUFFIX = new AtomicRangeInteger(0, 1000000);
    private final StorageHashMapBuilder<Record> storageBuilder;

    public RecordDAO(StorageHashMapBuilder<Record> storageBuilder) {
        this.storageBuilder = storageBuilder;
    }

    public InsertRequest prepareBatchInsert(Model model, Record record) {
        long timestamp = TimeBucket.getTimestamp((long)record.getTimeBucket(), (DownSampling)model.getDownsampling()) * 1000000L + (long)SUFFIX.getAndIncrement();
        InfluxInsertRequest request = new InfluxInsertRequest(model, record, this.storageBuilder).time(timestamp, TimeUnit.NANOSECONDS);
        TableMetaInfo.get(model.getName()).getStorageAndTagMap().forEach(request::addFieldAsTag);
        List rawTags = null;
        if ("segment".equals(model.getName())) {
            rawTags = ((SegmentRecord)record).getTagsRawData();
        } else if ("log".equals(model.getName())) {
            rawTags = ((LogRecord)record).getTags();
        } else if ("alarm_record".equals(model.getName())) {
            rawTags = ((AlarmRecord)record).getTags();
        }
        if (Objects.nonNull(rawTags)) {
            Map<String, List<Tag>> collect = rawTags.stream().collect(Collectors.groupingBy(Tag::getKey));
            collect.forEach((key, value) -> request.tag((String)key, "'" + Joiner.on((String)"'").join((Iterable)value.stream().map(Tag::getValue).collect(Collectors.toSet())) + "'"));
        }
        return request;
    }
}

