/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.PaginationUtils;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.event.Event;
import org.apache.skywalking.oap.server.core.query.type.event.EventQueryCondition;
import org.apache.skywalking.oap.server.core.query.type.event.EventType;
import org.apache.skywalking.oap.server.core.query.type.event.Events;
import org.apache.skywalking.oap.server.core.query.type.event.Source;
import org.apache.skywalking.oap.server.core.storage.query.IEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.SelectQueryImpl;
import org.influxdb.querybuilder.WhereNested;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventQueryDAO
implements IEventQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventQueryDAO.class);
    private final InfluxClient client;

    public Events queryEvents(EventQueryCondition condition) throws Exception {
        List<WhereQueryImpl<SelectQueryImpl>> whereQueries = this.buildWhereQueries(condition);
        this.buildQueryByCondition(whereQueries, condition);
        List<QueryResult.Result> results = this.execute(whereQueries.get(0), whereQueries.get(1));
        return this.buildEventsByQueryResult(results);
    }

    public Events queryEvents(List<EventQueryCondition> conditionList) throws Exception {
        List<WhereQueryImpl<SelectQueryImpl>> whereQueries = this.buildWhereQueries(conditionList.get(0));
        this.buildQueryByCondition(whereQueries, conditionList);
        List<QueryResult.Result> results = this.execute(whereQueries.get(0), whereQueries.get(1));
        return this.buildEventsByQueryResult(results);
    }

    protected Event parseSeriesValues(QueryResult.Series series, List<Object> values) {
        Event event = new Event();
        List columns = series.getColumns();
        HashMap data = new HashMap();
        for (int i = 1; i < columns.size(); ++i) {
            Object value = values.get(i);
            if (value instanceof StorageDataComplexObject) {
                value = ((StorageDataComplexObject)value).toStorageData();
            }
            data.put(columns.get(i), value);
        }
        event.setUuid((String)data.get("uuid"));
        String service = (String)data.get("service");
        String serviceInstance = (String)data.get("service_instance");
        String endpoint = (String)data.get("endpoint");
        event.setSource(new Source(service, serviceInstance, endpoint));
        event.setName((String)data.get("name"));
        event.setType(EventType.parse((String)((String)data.get("type"))));
        event.setMessage((String)data.get("message"));
        event.setParameters((String)data.get("parameters"));
        event.setStartTime(((Number)data.get("start_time")).longValue());
        event.setEndTime(((Number)data.get("end_time")).longValue());
        return event;
    }

    protected List<WhereQueryImpl<SelectQueryImpl>> buildWhereQueries(EventQueryCondition condition) {
        ArrayList<WhereQueryImpl<SelectQueryImpl>> queries = new ArrayList<WhereQueryImpl<SelectQueryImpl>>(2);
        PaginationUtils.Page page = PaginationUtils.INSTANCE.exchange(condition.getPaging());
        String topFunc = Order.DES.equals((Object)condition.getOrder()) ? "top" : "bottom";
        WhereQueryImpl recallWhereQuery = BuiltQuery.QueryBuilder.select((String[])new String[0]).raw("*::field").function(topFunc, new Object[]{"start_time", page.getLimit() + page.getFrom()}).from(this.client.getDatabase(), "events").where();
        SelectQueryImpl countQuery = BuiltQuery.QueryBuilder.select((String[])new String[0]).count((Object)"uuid").from(this.client.getDatabase(), "events");
        WhereQueryImpl countWhereQuery = countQuery.where();
        queries.add(countWhereQuery);
        queries.add(recallWhereQuery);
        return queries;
    }

    protected void buildQueryByCondition(List<WhereQueryImpl<SelectQueryImpl>> queries, EventQueryCondition condition) {
        Duration startTime;
        Source source;
        WhereQueryImpl<SelectQueryImpl> countWhereQuery = queries.get(0);
        WhereQueryImpl<SelectQueryImpl> recallWhereQuery = queries.get(1);
        if (!Strings.isNullOrEmpty((String)condition.getUuid())) {
            recallWhereQuery.and(BuiltQuery.QueryBuilder.eq((String)"uuid", (Object)condition.getUuid()));
            countWhereQuery.and(BuiltQuery.QueryBuilder.eq((String)"uuid", (Object)condition.getUuid()));
        }
        if ((source = condition.getSource()) != null) {
            if (!Strings.isNullOrEmpty((String)source.getService())) {
                recallWhereQuery.and(BuiltQuery.QueryBuilder.eq((String)"service", (Object)source.getService()));
                countWhereQuery.and(BuiltQuery.QueryBuilder.eq((String)"service", (Object)source.getService()));
            }
            if (!Strings.isNullOrEmpty((String)source.getServiceInstance())) {
                recallWhereQuery.and(BuiltQuery.QueryBuilder.eq((String)"service_instance", (Object)source.getServiceInstance()));
                countWhereQuery.and(BuiltQuery.QueryBuilder.eq((String)"service_instance", (Object)source.getServiceInstance()));
            }
            if (!Strings.isNullOrEmpty((String)source.getEndpoint())) {
                recallWhereQuery.and(BuiltQuery.QueryBuilder.contains((String)"endpoint", (String)source.getEndpoint().replaceAll("/", "\\\\/")));
                countWhereQuery.and(BuiltQuery.QueryBuilder.contains((String)"endpoint", (String)source.getEndpoint().replaceAll("/", "\\\\/")));
            }
        }
        if (!Strings.isNullOrEmpty((String)condition.getName())) {
            recallWhereQuery.and(BuiltQuery.QueryBuilder.eq((String)"\"name\"", (Object)condition.getName()));
            countWhereQuery.and(BuiltQuery.QueryBuilder.eq((String)"\"name\"", (Object)condition.getName()));
        }
        if (condition.getType() != null) {
            recallWhereQuery.and(BuiltQuery.QueryBuilder.eq((String)"type", (Object)condition.getType().name()));
            countWhereQuery.and(BuiltQuery.QueryBuilder.eq((String)"type", (Object)condition.getType().name()));
        }
        if ((startTime = condition.getTime()) != null) {
            if (startTime.getStartTimestamp() > 0L) {
                recallWhereQuery.and(BuiltQuery.QueryBuilder.gt((String)"start_time", (Object)startTime.getStartTimestamp()));
                countWhereQuery.and(BuiltQuery.QueryBuilder.gt((String)"start_time", (Object)startTime.getStartTimestamp()));
            }
            if (startTime.getEndTimestamp() > 0L) {
                recallWhereQuery.and(BuiltQuery.QueryBuilder.lt((String)"end_time", (Object)startTime.getEndTimestamp()));
                countWhereQuery.and(BuiltQuery.QueryBuilder.lt((String)"end_time", (Object)startTime.getEndTimestamp()));
            }
        }
    }

    protected void buildQueryByCondition(List<WhereQueryImpl<SelectQueryImpl>> queries, List<EventQueryCondition> conditions) {
        WhereQueryImpl<SelectQueryImpl> countWhereQuery = queries.get(0);
        WhereQueryImpl<SelectQueryImpl> recallWhereQuery = queries.get(1);
        conditions.stream().forEach(c -> {
            Duration startTime;
            Source source;
            WhereNested recallOrNested = recallWhereQuery.orNested();
            WhereNested countOrNested = countWhereQuery.orNested();
            if (!Strings.isNullOrEmpty((String)c.getUuid())) {
                recallWhereQuery.and(BuiltQuery.QueryBuilder.eq((String)"uuid", (Object)c.getUuid()));
                countWhereQuery.and(BuiltQuery.QueryBuilder.eq((String)"uuid", (Object)c.getUuid()));
            }
            if ((source = c.getSource()) != null) {
                if (!Strings.isNullOrEmpty((String)source.getService())) {
                    recallOrNested.and(BuiltQuery.QueryBuilder.eq((String)"service", (Object)source.getService()));
                    countOrNested.and(BuiltQuery.QueryBuilder.eq((String)"service", (Object)source.getService()));
                }
                if (!Strings.isNullOrEmpty((String)source.getServiceInstance())) {
                    recallOrNested.and(BuiltQuery.QueryBuilder.eq((String)"service_instance", (Object)source.getServiceInstance()));
                    countOrNested.and(BuiltQuery.QueryBuilder.eq((String)"service_instance", (Object)source.getServiceInstance()));
                }
                if (!Strings.isNullOrEmpty((String)source.getEndpoint())) {
                    recallOrNested.and(BuiltQuery.QueryBuilder.contains((String)"endpoint", (String)source.getEndpoint().replaceAll("/", "\\\\/")));
                    countOrNested.and(BuiltQuery.QueryBuilder.contains((String)"endpoint", (String)source.getEndpoint().replaceAll("/", "\\\\/")));
                }
            }
            if (!Strings.isNullOrEmpty((String)c.getName())) {
                recallOrNested.and(BuiltQuery.QueryBuilder.eq((String)"\"name\"", (Object)c.getName()));
                countOrNested.and(BuiltQuery.QueryBuilder.eq((String)"\"name\"", (Object)c.getName()));
            }
            if (c.getType() != null) {
                recallOrNested.and(BuiltQuery.QueryBuilder.eq((String)"type", (Object)c.getType().name()));
                countOrNested.and(BuiltQuery.QueryBuilder.eq((String)"type", (Object)c.getType().name()));
            }
            if ((startTime = c.getTime()) != null) {
                if (startTime.getStartTimestamp() > 0L) {
                    recallOrNested.and(BuiltQuery.QueryBuilder.gt((String)"start_time", (Object)startTime.getStartTimestamp()));
                    countOrNested.and(BuiltQuery.QueryBuilder.gt((String)"start_time", (Object)startTime.getStartTimestamp()));
                }
                if (startTime.getEndTimestamp() > 0L) {
                    recallOrNested.and(BuiltQuery.QueryBuilder.lt((String)"end_time", (Object)startTime.getEndTimestamp()));
                    countOrNested.and(BuiltQuery.QueryBuilder.lt((String)"end_time", (Object)startTime.getEndTimestamp()));
                }
            }
            recallOrNested.close();
            countOrNested.close();
        });
    }

    protected List<QueryResult.Result> execute(WhereQueryImpl<SelectQueryImpl> countWhereQuery, WhereQueryImpl<SelectQueryImpl> recallWhereQuery) throws IOException {
        Query query = new Query(countWhereQuery.getCommand() + recallWhereQuery.getCommand());
        List<QueryResult.Result> results = this.client.query(query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {}", (Object)query.getCommand());
            log.debug("Result: {}", results);
        }
        if (results.size() != 2) {
            throw new IOException("Expecting to get 2 Results, but it is " + results.size());
        }
        return results;
    }

    protected Events buildEventsByQueryResult(List<QueryResult.Result> results) {
        QueryResult.Series counterSeries = (QueryResult.Series)results.get(0).getSeries().get(0);
        List recallSeries = results.get(1).getSeries();
        Events events = new Events();
        events.setTotal(((Number)((List)counterSeries.getValues().get(0)).get(1)).longValue());
        recallSeries.forEach(series -> series.getValues().forEach(values -> events.getEvents().add(this.parseSeriesValues((QueryResult.Series)series, (List<Object>)values))));
        return events;
    }

    @Generated
    public EventQueryDAO(InfluxClient client) {
        this.client = client;
    }
}

