/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.NodeType;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.query.enumeration.Language;
import org.apache.skywalking.oap.server.core.query.type.Attribute;
import org.apache.skywalking.oap.server.core.query.type.Database;
import org.apache.skywalking.oap.server.core.query.type.Endpoint;
import org.apache.skywalking.oap.server.core.query.type.Service;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstance;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.QueryStringBuilder;
import org.influxdb.querybuilder.SelectQueryImpl;
import org.influxdb.querybuilder.SelectSubQueryImpl;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataQuery
implements IMetadataQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataQuery.class);
    private static final Gson GSON = new Gson();
    private final InfluxClient client;

    public List<Service> getAllServices(String group) throws IOException {
        WhereQueryImpl where = BuiltQuery.QueryBuilder.select((String[])new String[]{"id", "\"name\"", "service_group"}).from(this.client.getDatabase(), "service_traffic").where(BuiltQuery.QueryBuilder.eq((String)"_node_type", (Object)String.valueOf(NodeType.Normal.value())));
        if (StringUtil.isNotEmpty((String)group)) {
            where.and(BuiltQuery.QueryBuilder.eq((String)"_service_group", (Object)group));
        }
        return this.buildServices((Query)where);
    }

    public List<Service> getAllBrowserServices() throws IOException {
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[]{"id", "\"name\"", "service_group"}).from(this.client.getDatabase(), "service_traffic").where(BuiltQuery.QueryBuilder.eq((String)"_node_type", (Object)String.valueOf(NodeType.Browser.value())));
        return this.buildServices((Query)query);
    }

    public List<Database> getAllDatabases() throws IOException {
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[]{"id", "\"name\"", "service_group"}).from(this.client.getDatabase(), "service_traffic").where(BuiltQuery.QueryBuilder.eq((String)"_node_type", (Object)String.valueOf(NodeType.Database.value())));
        QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result: {}", (Object)query.getCommand(), (Object)series);
        }
        ArrayList databases = Lists.newArrayList();
        if (Objects.nonNull(series)) {
            for (List values : series.getValues()) {
                Database database = new Database();
                database.setId((String)values.get(1));
                database.setName((String)values.get(2));
                databases.add(database);
            }
        }
        return databases;
    }

    public List<Service> searchServices(String keyword) throws IOException {
        WhereQueryImpl where = BuiltQuery.QueryBuilder.select((String[])new String[]{"id", "\"name\"", "service_group"}).from(this.client.getDatabase(), "service_traffic").where(BuiltQuery.QueryBuilder.eq((String)"_node_type", (Object)String.valueOf(NodeType.Normal.value())));
        if (!Strings.isNullOrEmpty((String)keyword)) {
            where.and(BuiltQuery.QueryBuilder.contains((String)"\"name\"", (String)keyword));
        }
        return this.buildServices((Query)where);
    }

    public Service searchService(String serviceCode) throws IOException {
        WhereQueryImpl whereQuery = BuiltQuery.QueryBuilder.select((String[])new String[]{"id", "\"name\"", "service_group"}).from(this.client.getDatabase(), "service_traffic").where(BuiltQuery.QueryBuilder.eq((String)"_node_type", (Object)String.valueOf(NodeType.Normal.value())));
        whereQuery.and(BuiltQuery.QueryBuilder.eq((String)"\"name\"", (Object)serviceCode));
        return this.buildServices((Query)whereQuery).get(0);
    }

    public List<Endpoint> searchEndpoint(String keyword, String serviceId, int limit) throws IOException {
        WhereQueryImpl where = BuiltQuery.QueryBuilder.select((String[])new String[0]).column("id").column("\"name\"").from(this.client.getDatabase(), "endpoint_traffic").where(BuiltQuery.QueryBuilder.eq((String)"_service_id", (Object)String.valueOf(serviceId)));
        if (!Strings.isNullOrEmpty((String)keyword)) {
            where.and(BuiltQuery.QueryBuilder.contains((String)"\"name\"", (String)keyword.replaceAll("/", "\\\\/")));
        }
        where.limit(limit);
        QueryResult.Series series = this.client.queryForSingleSeries((Query)where);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result: {}.", (Object)where.getCommand(), (Object)series);
        }
        ArrayList<Endpoint> list = new ArrayList<Endpoint>(limit);
        if (series != null) {
            series.getValues().forEach(values -> {
                Endpoint endpoint = new Endpoint();
                endpoint.setId((String)values.get(1));
                endpoint.setName((String)values.get(2));
                list.add(endpoint);
            });
        }
        return list;
    }

    public List<ServiceInstance> getServiceInstances(long startTimestamp, long endTimestamp, String serviceId) throws IOException {
        long minuteTimeBucket = TimeBucket.getMinuteTimeBucket((long)startTimestamp);
        SelectSubQueryImpl subQuery = (SelectSubQueryImpl)BuiltQuery.QueryBuilder.select((String[])new String[0]).fromSubQuery(this.client.getDatabase()).column("id").column("\"name\"").column("properties").from("instance_traffic").where().and(BuiltQuery.QueryBuilder.gte((String)"last_ping", (Object)minuteTimeBucket)).and(BuiltQuery.QueryBuilder.eq((String)"_service_id", (Object)serviceId)).groupBy(new Object[]{"_name_"});
        SelectQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).column("id").column("\"name\"").column("properties").from(this.client.getDatabase(), "instance_traffic");
        query.setSubQuery((QueryStringBuilder)subQuery);
        QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result: {}", (Object)query.getCommand(), (Object)series);
        }
        if (Objects.isNull(series)) {
            return Collections.emptyList();
        }
        List result = series.getValues();
        ArrayList instances = Lists.newArrayList();
        for (List values : result) {
            ServiceInstance serviceInstance = new ServiceInstance();
            serviceInstance.setId((String)values.get(1));
            serviceInstance.setName((String)values.get(2));
            serviceInstance.setInstanceUUID(serviceInstance.getId());
            String propertiesString = (String)values.get(3);
            if (!Strings.isNullOrEmpty((String)propertiesString)) {
                JsonObject properties = (JsonObject)GSON.fromJson(propertiesString, JsonObject.class);
                for (Map.Entry property : properties.entrySet()) {
                    String key = (String)property.getKey();
                    String value = ((JsonElement)property.getValue()).getAsString();
                    if (key.equals("language")) {
                        serviceInstance.setLanguage(Language.value((String)value));
                        continue;
                    }
                    serviceInstance.getAttributes().add(new Attribute(key, value));
                }
            } else {
                serviceInstance.setLanguage(Language.UNKNOWN);
            }
            instances.add(serviceInstance);
        }
        return instances;
    }

    private List<Service> buildServices(Query query) throws IOException {
        QueryResult.Series series = this.client.queryForSingleSeries(query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result: {}", (Object)query.getCommand(), (Object)series);
        }
        ArrayList services = Lists.newArrayList();
        if (Objects.nonNull(series)) {
            for (List values : series.getValues()) {
                Service service = new Service();
                service.setId((String)values.get(1));
                service.setName((String)values.get(2));
                service.setGroup((String)values.get(3));
                services.add(service);
            }
        }
        return services;
    }

    @Generated
    public MetadataQuery(InfluxClient client) {
        this.client = client;
    }
}

