/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.base;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.endpoint.EndpointTraffic;
import org.apache.skywalking.oap.server.core.analysis.manual.instance.InstanceTraffic;
import org.apache.skywalking.oap.server.core.analysis.manual.service.ServiceTraffic;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.StorageHashMapBuilder;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.UpdateRequest;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.TableMetaInfo;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.base.InfluxInsertRequest;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.clauses.Clause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsDAO
implements IMetricsDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsDAO.class);
    private final StorageHashMapBuilder<Metrics> storageBuilder;
    private final InfluxClient client;

    public MetricsDAO(InfluxClient client, StorageHashMapBuilder<Metrics> storageBuilder) {
        this.client = client;
        this.storageBuilder = storageBuilder;
    }

    public List<Metrics> multiGet(Model model, List<Metrics> metrics) throws IOException {
        String queryStr;
        TableMetaInfo metaInfo = TableMetaInfo.get(model.getName());
        if (model.getName().endsWith("_traffic")) {
            Function<Metrics, Clause> clauseFunction;
            switch (model.getName()) {
                case "endpoint_traffic": {
                    clauseFunction = m -> BuiltQuery.QueryBuilder.eq((String)"_service_id", (Object)((EndpointTraffic)m).getServiceId());
                    break;
                }
                case "service_traffic": {
                    clauseFunction = m -> BuiltQuery.QueryBuilder.eq((String)"_name_", (Object)((ServiceTraffic)m).getName());
                    break;
                }
                case "instance_traffic": {
                    clauseFunction = m -> BuiltQuery.QueryBuilder.eq((String)"_service_id", (Object)((InstanceTraffic)m).getServiceId());
                    break;
                }
                default: {
                    throw new IOException("Unknown metadata type, " + model.getName());
                }
            }
            queryStr = metrics.stream().map(m -> BuiltQuery.QueryBuilder.select((String[])new String[0]).raw("*::field").from(this.client.getDatabase(), model.getName()).where((Clause)clauseFunction.apply((Metrics)m)).and(BuiltQuery.QueryBuilder.eq((String)"id", (Object)m.id())).buildQueryString()).collect(Collectors.joining(";"));
        } else {
            queryStr = metrics.stream().map(m -> BuiltQuery.QueryBuilder.select((String[])new String[0]).raw("*::field").from(this.client.getDatabase(), model.getName()).where(BuiltQuery.QueryBuilder.eq((String)"_time_bucket", (Object)String.valueOf(m.getTimeBucket()))).and(BuiltQuery.QueryBuilder.eq((String)"id", (Object)m.id())).buildQueryString()).collect(Collectors.joining(";"));
        }
        Query query = new Query(queryStr);
        List<QueryResult.Result> results = this.client.query(query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result: {}", (Object)query.getCommand(), results);
        }
        if (CollectionUtils.isEmpty(results)) {
            return Collections.emptyList();
        }
        ArrayList newMetrics = Lists.newArrayList();
        Map<String, String> storageAndColumnMap = metaInfo.getStorageAndColumnMap();
        results.stream().map(QueryResult.Result::getSeries).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).forEach(series -> {
            List columns = series.getColumns();
            series.getValues().forEach(values -> {
                HashMap data = Maps.newHashMap();
                for (int i = 1; i < columns.size(); ++i) {
                    Object value = values.get(i);
                    if (value instanceof StorageDataComplexObject) {
                        value = ((StorageDataComplexObject)value).toStorageData();
                    }
                    data.put(storageAndColumnMap.get(columns.get(i)), value);
                }
                newMetrics.add(this.storageBuilder.storage2Entity((Map)data));
            });
        });
        return newMetrics;
    }

    public InsertRequest prepareBatchInsert(Model model, Metrics metrics) {
        long timestamp = TimeBucket.getTimestamp((long)metrics.getTimeBucket(), (DownSampling)model.getDownsampling());
        TableMetaInfo tableMetaInfo = TableMetaInfo.get(model.getName());
        InfluxInsertRequest request = new InfluxInsertRequest(model, metrics, this.storageBuilder).time(timestamp, TimeUnit.MILLISECONDS);
        tableMetaInfo.getStorageAndTagMap().forEach(request::addFieldAsTag);
        return request;
    }

    public UpdateRequest prepareBatchUpdate(Model model, Metrics metrics) {
        return (UpdateRequest)this.prepareBatchInsert(model, metrics);
    }
}

