/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.TraceScopeCondition;
import org.apache.skywalking.oap.server.core.query.type.ContentType;
import org.apache.skywalking.oap.server.core.query.type.Log;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.SelectQueryImpl;
import org.influxdb.querybuilder.WhereNested;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.influxdb.querybuilder.clauses.Clause;
import org.influxdb.querybuilder.clauses.ConjunctionClause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogQuery
implements ILogQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogQuery.class);
    private final InfluxClient client;

    public LogQuery(InfluxClient client) {
        this.client = client;
    }

    public Logs queryLogs(String serviceId, String serviceInstanceId, String endpointId, TraceScopeCondition relatedTrace, Order queryOrder, int from, int limit, long startTB, long endTB, List<Tag> tags, List<String> keywordsOfContent, List<String> excludingKeywordsOfContent) throws IOException {
        WhereQueryImpl recallQuery = BuiltQuery.QueryBuilder.select((String[])new String[0]).raw("*::field").function(Order.DES.equals((Object)queryOrder) ? "top" : "bottom", new Object[]{"timestamp", limit + from}).from(this.client.getDatabase(), "log").where();
        if (StringUtil.isNotEmpty((String)serviceId)) {
            recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"_service_id", (Object)serviceId));
        }
        if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
            recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"service_instance_id", (Object)serviceInstanceId));
        }
        if (StringUtil.isNotEmpty((String)endpointId)) {
            recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"endpoint_id", (Object)endpointId));
        }
        if (Objects.nonNull(relatedTrace)) {
            if (StringUtil.isNotEmpty((String)relatedTrace.getTraceId())) {
                recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"trace_id", (Object)relatedTrace.getTraceId()));
            }
            if (StringUtil.isNotEmpty((String)relatedTrace.getSegmentId())) {
                recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"trace_segment_id", (Object)relatedTrace.getSegmentId()));
            }
            if (Objects.nonNull(relatedTrace.getSpanId())) {
                recallQuery.and(BuiltQuery.QueryBuilder.eq((String)"span_id", (Object)relatedTrace.getSpanId()));
            }
        }
        if (startTB != 0L && endTB != 0L) {
            recallQuery.and(BuiltQuery.QueryBuilder.gte((String)"time_bucket", (Object)startTB)).and(BuiltQuery.QueryBuilder.lte((String)"time_bucket", (Object)endTB));
        }
        if (CollectionUtils.isNotEmpty(tags)) {
            WhereNested nested = recallQuery.andNested();
            for (Tag tag : tags) {
                nested.and(BuiltQuery.QueryBuilder.contains((String)tag.getKey(), (String)("'" + tag.getValue() + "'")));
            }
            nested.close();
        }
        SelectQueryImpl countQuery = BuiltQuery.QueryBuilder.select((String[])new String[0]).count((Object)"service_id").from(this.client.getDatabase(), "log");
        for (ConjunctionClause clause : recallQuery.getClauses()) {
            countQuery.where((Clause)clause);
        }
        Query query = new Query(countQuery.getCommand() + recallQuery.getCommand());
        List<QueryResult.Result> results = this.client.query(query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} \nresult set: {}", (Object)query.getCommand(), results);
        }
        if (results.size() != 2) {
            throw new IOException("Expecting to get 2 Results, but it is " + results.size());
        }
        Logs logs = new Logs();
        QueryResult.Result counter = results.get(0);
        QueryResult.Result seriesList = results.get(1);
        logs.setTotal(((Number)((List)((QueryResult.Series)counter.getSeries().get(0)).getValues().get(0)).get(1)).intValue());
        seriesList.getSeries().forEach(series -> {
            List columns = series.getColumns();
            series.getValues().forEach(values -> {
                HashMap data = Maps.newHashMap();
                Log log = new Log();
                for (int i = 1; i < columns.size(); ++i) {
                    Object value = values.get(i);
                    if (value instanceof StorageDataComplexObject) {
                        value = ((StorageDataComplexObject)value).toStorageData();
                    }
                    data.put(columns.get(i), value);
                }
                log.setServiceId((String)data.get("service_id"));
                log.setServiceInstanceId((String)data.get("service_instance_id"));
                log.setEndpointId((String)data.get("endpoint_id"));
                if (log.getEndpointId() != null) {
                    log.setEndpointName(IDManager.EndpointID.analysisId((String)log.getEndpointId()).getEndpointName());
                }
                log.setTraceId((String)data.get("trace_id"));
                log.setTimestamp(Long.valueOf(((Number)data.get("timestamp")).longValue()));
                log.setContentType(ContentType.instanceOf((int)((Number)data.get("content_type")).intValue()));
                log.setContent((String)data.get("content"));
                String dataBinaryBase64 = (String)data.get("tags_raw_data");
                if (!Strings.isNullOrEmpty((String)dataBinaryBase64)) {
                    this.parserDataBinary(dataBinaryBase64, log.getTags());
                }
                logs.getLogs().add(log);
            });
        });
        return logs;
    }
}

