/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.type.ProfileTask;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.SelectQueryImpl;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileTaskQuery
implements IProfileTaskQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileTaskQuery.class);
    private final InfluxClient client;

    public ProfileTaskQuery(InfluxClient client) {
        this.client = client;
    }

    public List<ProfileTask> getTaskList(String serviceId, String endpointName, Long startTimeBucket, Long endTimeBucket, Integer limit) throws IOException {
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[]{"id", "service_id", "endpoint_name", "start_time", "create_time", "\"duration\"", "min_duration_threshold", "dump_period", "max_sampling_count"}).from(this.client.getDatabase(), "profile_task").where();
        if (StringUtil.isNotEmpty((String)serviceId)) {
            query.and(BuiltQuery.QueryBuilder.eq((String)"_service_id", (Object)serviceId));
        }
        if (StringUtil.isNotEmpty((String)endpointName)) {
            query.and(BuiltQuery.QueryBuilder.eq((String)"endpoint_name", (Object)endpointName));
        }
        if (Objects.nonNull(startTimeBucket)) {
            query.and(BuiltQuery.QueryBuilder.gte((String)"time_bucket", (Object)startTimeBucket));
        }
        if (Objects.nonNull(endTimeBucket)) {
            query.and(BuiltQuery.QueryBuilder.lte((String)"time_bucket", (Object)endTimeBucket));
        }
        if (Objects.nonNull(limit)) {
            query.limit(limit.intValue());
        }
        ArrayList tasks = Lists.newArrayList();
        QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result: {}", (Object)query.getCommand(), (Object)series);
        }
        if (series != null) {
            series.getValues().forEach(values -> tasks.add(ProfileTaskQuery.profileTaskBuilder(values)));
        }
        return tasks;
    }

    public ProfileTask getById(String id) throws IOException {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        SelectQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[]{"id", "service_id", "endpoint_name", "start_time", "create_time", "\"duration\"", "min_duration_threshold", "dump_period", "max_sampling_count"}).from(this.client.getDatabase(), "profile_task").where().and(BuiltQuery.QueryBuilder.eq((String)"id", (Object)id)).limit(1);
        QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result: {}", (Object)query.getCommand(), (Object)series);
        }
        if (Objects.nonNull(series)) {
            return ProfileTaskQuery.profileTaskBuilder((List)series.getValues().get(0));
        }
        return null;
    }

    private static ProfileTask profileTaskBuilder(List<Object> values) {
        return ProfileTask.builder().id((String)values.get(1)).serviceId((String)values.get(2)).endpointName((String)values.get(3)).startTime(((Number)values.get(4)).longValue()).createTime(((Number)values.get(5)).longValue()).duration(((Number)values.get(6)).intValue()).minDurationThreshold(((Number)values.get(7)).intValue()).dumpPeriod(((Number)values.get(8)).intValue()).maxSamplingCount(((Number)values.get(9)).intValue()).build();
    }
}

