/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.zipkin;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.SuperDataset;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

@SuperDataset
@Stream(name="zipkin_span", scopeId=23, builder=Builder.class, processor=RecordStreamProcessor.class)
public class ZipkinSpanRecord
extends Record {
    public static final String INDEX_NAME = "zipkin_span";
    public static final String TRACE_ID = "trace_id";
    public static final String SPAN_ID = "span_id";
    public static final String SERVICE_ID = "service_id";
    public static final String SERVICE_INSTANCE_ID = "service_instance_id";
    public static final String ENDPOINT_NAME = "endpoint_name";
    public static final String ENDPOINT_ID = "endpoint_id";
    public static final String START_TIME = "start_time";
    public static final String END_TIME = "end_time";
    public static final String LATENCY = "latency";
    public static final String IS_ERROR = "is_error";
    public static final String DATA_BINARY = "data_binary";
    public static final String ENCODE = "encode";
    @Column(columnName="trace_id")
    private String traceId;
    @Column(columnName="span_id")
    private String spanId;
    @Column(columnName="service_id")
    private String serviceId;
    @Column(columnName="service_instance_id")
    private String serviceInstanceId;
    @Column(columnName="endpoint_name", matchQuery=true)
    private String endpointName;
    @Column(columnName="endpoint_id")
    private String endpointId;
    @Column(columnName="start_time")
    private long startTime;
    @Column(columnName="end_time")
    private long endTime;
    @Column(columnName="latency")
    private int latency;
    @Column(columnName="is_error")
    private int isError;
    @Column(columnName="data_binary")
    private byte[] dataBinary;
    @Column(columnName="encode")
    private int encode;

    public String id() {
        return this.traceId + "-" + this.spanId;
    }

    @Generated
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public void setSpanId(String spanId) {
        this.spanId = spanId;
    }

    @Generated
    public String getSpanId() {
        return this.spanId;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public void setServiceInstanceId(String serviceInstanceId) {
        this.serviceInstanceId = serviceInstanceId;
    }

    @Generated
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    @Generated
    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    @Generated
    public String getEndpointName() {
        return this.endpointName;
    }

    @Generated
    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    @Generated
    public String getEndpointId() {
        return this.endpointId;
    }

    @Generated
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Generated
    public void setLatency(int latency) {
        this.latency = latency;
    }

    @Generated
    public int getLatency() {
        return this.latency;
    }

    @Generated
    public void setIsError(int isError) {
        this.isError = isError;
    }

    @Generated
    public int getIsError() {
        return this.isError;
    }

    @Generated
    public void setDataBinary(byte[] dataBinary) {
        this.dataBinary = dataBinary;
    }

    @Generated
    public byte[] getDataBinary() {
        return this.dataBinary;
    }

    @Generated
    public void setEncode(int encode) {
        this.encode = encode;
    }

    @Generated
    public int getEncode() {
        return this.encode;
    }

    public static class Builder
    implements StorageBuilder<ZipkinSpanRecord> {
        public Map<String, Object> data2Map(ZipkinSpanRecord storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(ZipkinSpanRecord.TRACE_ID, storageData.getTraceId());
            map.put(ZipkinSpanRecord.SPAN_ID, storageData.getSpanId());
            map.put(ZipkinSpanRecord.SERVICE_ID, storageData.getServiceId());
            map.put(ZipkinSpanRecord.SERVICE_INSTANCE_ID, storageData.getServiceInstanceId());
            map.put(ZipkinSpanRecord.ENDPOINT_NAME, storageData.getEndpointName());
            map.put(ZipkinSpanRecord.ENDPOINT_ID, storageData.getEndpointId());
            map.put(ZipkinSpanRecord.START_TIME, storageData.getStartTime());
            map.put(ZipkinSpanRecord.END_TIME, storageData.getEndTime());
            map.put(ZipkinSpanRecord.LATENCY, storageData.getLatency());
            map.put(ZipkinSpanRecord.IS_ERROR, storageData.getIsError());
            map.put("time_bucket", storageData.getTimeBucket());
            if (CollectionUtils.isEmpty((byte[])storageData.getDataBinary())) {
                map.put(ZipkinSpanRecord.DATA_BINARY, "");
            } else {
                map.put(ZipkinSpanRecord.DATA_BINARY, new String(Base64.getEncoder().encode(storageData.getDataBinary())));
            }
            map.put(ZipkinSpanRecord.ENCODE, storageData.getEncode());
            return map;
        }

        public ZipkinSpanRecord map2Data(Map<String, Object> dbMap) {
            ZipkinSpanRecord record = new ZipkinSpanRecord();
            record.setTraceId((String)dbMap.get(ZipkinSpanRecord.TRACE_ID));
            record.setSpanId((String)dbMap.get(ZipkinSpanRecord.SPAN_ID));
            record.setServiceId((String)dbMap.get(ZipkinSpanRecord.SERVICE_ID));
            record.setServiceInstanceId((String)dbMap.get(ZipkinSpanRecord.SERVICE_INSTANCE_ID));
            record.setEndpointName((String)dbMap.get(ZipkinSpanRecord.ENDPOINT_NAME));
            record.setEndpointId((String)dbMap.get(ZipkinSpanRecord.ENDPOINT_ID));
            record.setStartTime(((Number)dbMap.get(ZipkinSpanRecord.START_TIME)).longValue());
            record.setEndTime(((Number)dbMap.get(ZipkinSpanRecord.END_TIME)).longValue());
            record.setLatency(((Number)dbMap.get(ZipkinSpanRecord.LATENCY)).intValue());
            record.setIsError(((Number)dbMap.get(ZipkinSpanRecord.IS_ERROR)).intValue());
            record.setTimeBucket(((Number)dbMap.get("time_bucket")).longValue());
            if (StringUtil.isEmpty((String)((String)dbMap.get(ZipkinSpanRecord.DATA_BINARY)))) {
                record.setDataBinary(new byte[0]);
            } else {
                record.setDataBinary(Base64.getDecoder().decode((String)dbMap.get(ZipkinSpanRecord.DATA_BINARY)));
            }
            record.setEncode(((Number)dbMap.get(ZipkinSpanRecord.ENCODE)).intValue());
            return record;
        }
    }
}

