/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.telemetry.prometheus;

import io.prometheus.client.SimpleCollector;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.skywalking.oap.server.telemetry.api.MetricTag;
import org.apache.skywalking.oap.server.telemetry.api.TelemetryRelatedContext;

public abstract class BaseMetric<T extends SimpleCollector, C> {
    private static Map<String, Object> ALL_METRICS = new HashMap<String, Object>();
    private volatile C metricInstance;
    protected final String name;
    protected final String tips;
    protected final MetricTag.Keys labels;
    protected final MetricTag.Values values;
    private ReentrantLock lock = new ReentrantLock();

    public BaseMetric(String name, String tips, MetricTag.Keys labels, MetricTag.Values values) {
        this.name = name;
        this.tips = tips;
        this.labels = labels;
        this.values = values;
    }

    protected boolean isIDReady() {
        return TelemetryRelatedContext.INSTANCE.getId() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected C getMetric() {
        block11: {
            if (this.metricInstance == null && this.isIDReady()) {
                this.lock.lock();
                try {
                    if (this.metricInstance != null) break block11;
                    String[] labelNames = new String[this.labels.getKeys().length + 1];
                    labelNames[0] = "sw_backend_instance";
                    for (int i = 0; i < this.labels.getKeys().length; ++i) {
                        labelNames[i + 1] = this.labels.getKeys()[i];
                    }
                    String[] labelValues = new String[this.values.getValues().length + 1];
                    labelValues[0] = TelemetryRelatedContext.INSTANCE.getId();
                    for (int i = 0; i < this.values.getValues().length; ++i) {
                        labelValues[i + 1] = this.values.getValues()[i];
                    }
                    if (!ALL_METRICS.containsKey(this.name)) {
                        Map<String, Object> i = ALL_METRICS;
                        synchronized (i) {
                            if (!ALL_METRICS.containsKey(this.name)) {
                                ALL_METRICS.put(this.name, this.create(labelNames));
                            }
                        }
                    }
                    SimpleCollector metric = (SimpleCollector)ALL_METRICS.get(this.name);
                    this.metricInstance = metric.labels(labelValues);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        return this.metricInstance;
    }

    protected abstract T create(String[] var1);
}

