/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.telemetry.prometheus;

import io.prometheus.client.Histogram;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetric;
import org.apache.skywalking.oap.server.telemetry.api.MetricTag;
import org.apache.skywalking.oap.server.telemetry.prometheus.BaseMetric;

public class PrometheusHistogramMetric
extends HistogramMetric {
    private InnerMetricObject inner;
    private final double[] buckets;

    public PrometheusHistogramMetric(String name, String tips, MetricTag.Keys labels, MetricTag.Values values, double ... buckets) {
        this.inner = new InnerMetricObject(name, tips, labels, values);
        this.buckets = buckets;
    }

    public void observe(double value) {
        Histogram.Child metric = (Histogram.Child)this.inner.getMetric();
        if (metric != null) {
            metric.observe(value);
        }
    }

    class InnerMetricObject
    extends BaseMetric<Histogram, Histogram.Child> {
        public InnerMetricObject(String name, String tips, MetricTag.Keys labels, MetricTag.Values values) {
            super(name, tips, labels, values);
        }

        @Override
        protected Histogram create(String[] labelNames) {
            Histogram.Builder builder = (Histogram.Builder)((Histogram.Builder)Histogram.build().name(this.name)).help(this.tips);
            if (builder != null && PrometheusHistogramMetric.this.buckets.length > 0) {
                builder = builder.buckets(PrometheusHistogramMetric.this.buckets);
            }
            return (Histogram)((Histogram.Builder)builder.labelNames(labelNames)).register();
        }
    }
}

