/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.api.types;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.slider.api.SliderExitReason;
import org.apache.slider.api.types.ContainerInformation;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ApplicationDiagnostics {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationDiagnostics.class);
    @JsonIgnore
    private Map<String, ContainerInformation> containersMap = new HashMap<String, ContainerInformation>();
    private FinalApplicationStatus finalStatus;
    private String finalMessage;
    private SliderExitReason exitReason;
    private Set<ContainerInformation> containers = new HashSet<ContainerInformation>();
    private Set<String> recentFailedContainers = new HashSet<String>();

    public Collection<ContainerInformation> getContainers() {
        return Collections.unmodifiableCollection(this.containers);
    }

    public ContainerInformation getContainer(String containerId) {
        return this.containersMap.get(containerId);
    }

    public void addContainer(ContainerInformation container) {
        if (container == null) {
            return;
        }
        this.containersMap.put(container.containerId, container);
        this.containers.add(container);
    }

    public Collection<String> getRecentFailedContainers() {
        return Collections.unmodifiableCollection(this.recentFailedContainers);
    }

    public void setRecentFailedContainers(Collection<String> containerIds) {
        if (containerIds != null) {
            this.recentFailedContainers = new HashSet<String>(containerIds);
        }
    }

    public void addRecentFailedContainer(String containerId) {
        if (containerId == null) {
            return;
        }
        this.recentFailedContainers.add(containerId);
    }

    public FinalApplicationStatus getFinalStatus() {
        return this.finalStatus;
    }

    public void setFinalStatus(FinalApplicationStatus finalStatus) {
        this.finalStatus = finalStatus;
    }

    public String getFinalMessage() {
        return this.finalMessage;
    }

    public void setFinalMessage(String finalMessage) {
        this.finalMessage = finalMessage;
    }

    public SliderExitReason getExitReason() {
        return this.exitReason;
    }

    public void setExitReason(SliderExitReason exitReason) {
        this.exitReason = exitReason;
    }

    public String toString() {
        try {
            return this.toJsonString();
        }
        catch (Exception e) {
            logger.debug("Failed to convert ApplicationDiagnostics to JSON ", (Throwable)e);
            return super.toString();
        }
    }

    public String toJsonString() throws IOException, JsonGenerationException, JsonMappingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        return mapper.writeValueAsString((Object)this);
    }

    public static ApplicationDiagnostics fromJson(String json) throws IOException, JsonParseException, JsonMappingException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (ApplicationDiagnostics)mapper.readValue(json, ApplicationDiagnostics.class);
        }
        catch (IOException e) {
            logger.error("Exception while parsing json : " + e + "\n" + json, (Throwable)e);
            throw e;
        }
    }
}

