/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.common.tools;

import java.io.Serializable;
import java.util.Comparator;

public class Comparators {

    public static class ComparatorReverser<CompareType>
    implements Comparator<CompareType>,
    Serializable {
        final Comparator<CompareType> instance;

        public ComparatorReverser(Comparator<CompareType> instance) {
            this.instance = instance;
        }

        @Override
        public int compare(CompareType first, CompareType second) {
            return this.instance.compare(second, first);
        }
    }

    public static class InvertedLongComparator
    implements Comparator<Long>,
    Serializable {
        private static final LongComparator inner = new LongComparator();

        @Override
        public int compare(Long o1, Long o2) {
            return -inner.compare(o1, o2);
        }
    }

    public static class LongComparator
    implements Comparator<Long>,
    Serializable {
        @Override
        public int compare(Long o1, Long o2) {
            long result = o1 - o2;
            if (result < 0L) {
                return -1;
            }
            if (result > 0L) {
                return 1;
            }
            return 0;
        }
    }
}

