/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.common.tools;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.GlobFilter;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.slider.Slider;
import org.apache.slider.api.types.ContainerInformation;
import org.apache.slider.common.tools.ConfigHelper;
import org.apache.slider.common.tools.CoreFileSystem;
import org.apache.slider.common.tools.SliderFileSystem;
import org.apache.slider.common.tools.SliderVersionInfo;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.BadClusterStateException;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.launch.ClasspathConstructor;
import org.apache.slider.server.services.utility.PatternValidator;
import org.apache.slider.server.services.workflow.ForkedProcessService;
import org.apache.zookeeper.server.util.KerberosUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SliderUtils {
    private static final Logger log = LoggerFactory.getLogger(SliderUtils.class);
    private static final AtomicBoolean processSecurityAlreadyInitialized = new AtomicBoolean(false);
    public static final String JAVA_SECURITY_KRB5_REALM = "java.security.krb5.realm";
    public static final String JAVA_SECURITY_KRB5_KDC = "java.security.krb5.kdc";
    public static final String WINUTILS = "WINUTILS.EXE";
    public static final String OPENSSL = "openssl";
    public static final String PYTHON = "python";
    public static final String DOCKER = "docker";
    public static final String DOCKER_YARN = "yarn_docker";
    public static final int NODE_LIST_LIMIT = 10;
    private static final PatternValidator clusternamePattern = new PatternValidator("[a-z][a-z0-9_-]*");

    private SliderUtils() {
    }

    public static boolean isUnset(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isSet(String s) {
        return !SliderUtils.isUnset(s);
    }

    public static boolean isNotEmpty(List l) {
        return l != null && !l.isEmpty();
    }

    public static boolean isNotEmpty(Map m) {
        return m != null && !m.isEmpty();
    }

    private static void validateNumber(String num, String msg) throws BadConfigException {
        try {
            Integer.parseInt(num);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadConfigException(String.valueOf(msg) + num);
        }
    }

    public static String translateTrailingHeapUnit(String heapsize) throws BadConfigException {
        String errMsg = "Bad heapsize: ";
        if (heapsize.endsWith("m") || heapsize.endsWith("M")) {
            String num = heapsize.substring(0, heapsize.length() - 1);
            SliderUtils.validateNumber(num, errMsg);
            return num;
        }
        if (heapsize.endsWith("g") || heapsize.endsWith("G")) {
            String num = String.valueOf(heapsize.substring(0, heapsize.length() - 1)) + "000";
            SliderUtils.validateNumber(num, errMsg);
            return num;
        }
        SliderUtils.validateNumber(heapsize, errMsg);
        return heapsize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteDirectoryTree(File dir) throws IOException {
        if (dir.exists()) {
            if (!dir.isDirectory()) throw new IOException("Not a directory " + dir);
            log.info("Cleaning up {}", (Object)dir);
            File[] files = dir.listFiles();
            if (files == null) {
                throw new IOException("listfiles() failed for " + dir);
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                log.info("deleting {}", (Object)file);
                if (!file.delete()) {
                    log.warn("Unable to delete " + file);
                }
                ++n2;
            }
            if (dir.delete()) return;
            log.warn("Unable to delete " + dir);
            return;
        } else {
            log.debug("No output dir yet");
        }
    }

    public static File findContainingJarOrFail(Class clazz) throws IOException {
        File localFile = SliderUtils.findContainingJar(clazz);
        if (localFile == null) {
            throw new FileNotFoundException("Could not find JAR containing " + clazz);
        }
        return localFile;
    }

    /*
     * Unable to fully structure code
     */
    public static File findContainingJar(Class my_class) throws IOException {
        loader = my_class.getClassLoader();
        if (loader == null) {
            throw new IOException("Class " + my_class + " does not have a classloader!");
        }
        class_file = String.valueOf(my_class.getName().replaceAll("\\.", "/")) + ".class";
        urlEnumeration = loader.getResources(class_file);
        if (urlEnumeration != null) ** GOTO lbl18
        throw new IOException("Unable to find resources for class " + my_class);
lbl-1000:
        // 1 sources

        {
            url = urlEnumeration.nextElement();
            if ("jar".equals(url.getProtocol())) {
                toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = toReturn.replaceAll("\\+", "%2B");
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                jarFilePath = toReturn.replaceAll("!.*$", "");
                return new File(jarFilePath);
            }
            SliderUtils.log.info("could not locate JAR containing {} URL={}", (Object)my_class, (Object)url);
lbl18:
            // 2 sources

            ** while (urlEnumeration.hasMoreElements())
        }
lbl19:
        // 1 sources

        return null;
    }

    public static void checkPort(String hostname, int port, int connectTimeout) throws IOException {
        InetSocketAddress addr = new InetSocketAddress(hostname, port);
        SliderUtils.checkPort(hostname, addr, connectTimeout);
    }

    public static void checkPort(String name, InetSocketAddress address, int connectTimeout) throws IOException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Socket socket = new Socket();){
                socket.connect(address, connectTimeout);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to connect to " + name + " at " + address + " after " + connectTimeout + "milliseconds" + ": " + e, e);
        }
    }

    public static void checkURL(String name, String url, int timeout) throws IOException {
        InetSocketAddress address = NetUtils.createSocketAddr((String)url);
        SliderUtils.checkPort(name, address, timeout);
    }

    public static File requiredFile(String filename, String role) throws IOException {
        if (filename.isEmpty()) {
            throw new ExitUtil.ExitException(-1, String.valueOf(role) + " file not defined");
        }
        File file = new File(filename);
        if (!file.exists()) {
            throw new ExitUtil.ExitException(-1, String.valueOf(role) + " file not found: " + file.getCanonicalPath());
        }
        return file;
    }

    public static boolean isClusternameValid(String name) {
        return name != null && clusternamePattern.matches(name);
    }

    public static boolean oldIsClusternameValid(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        char first = name.charAt(0);
        if ((Character.getType((int)first) & 2) == 0) {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            char elt = name.charAt(i);
            int t = Character.getType((int)elt);
            if ((t & 2) == 0 && (t & 9) == 0 && elt != '-' && elt != '_') {
                return false;
            }
            if (!Character.isLetterOrDigit((int)elt) && elt != '-' && elt != '_') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int copyDirectory(Configuration conf, Path srcDirPath, Path destDirPath, FsPermission permission) throws IOException, BadClusterStateException {
        FileSystem srcFS = FileSystem.get((URI)srcDirPath.toUri(), (Configuration)conf);
        FileSystem destFS = FileSystem.get((URI)destDirPath.toUri(), (Configuration)conf);
        if (!srcFS.exists(srcDirPath)) {
            throw new FileNotFoundException("Source dir not found " + srcDirPath);
        }
        if (!srcFS.isDirectory(srcDirPath)) {
            throw new FileNotFoundException("Source dir not a directory " + srcDirPath);
        }
        GlobFilter dotFilter = new GlobFilter("[!.]*");
        FileStatus[] entries = srcFS.listStatus(srcDirPath, (PathFilter)dotFilter);
        int srcFileCount = entries.length;
        if (srcFileCount == 0) {
            return 0;
        }
        if (permission == null) {
            permission = FsPermission.getDirDefault();
        }
        if (!destFS.exists(destDirPath)) {
            new SliderFileSystem(destFS, conf).createWithPermissions(destDirPath, permission);
        }
        Path[] sourcePaths = new Path[srcFileCount];
        int i = 0;
        while (i < srcFileCount) {
            FileStatus e = entries[i];
            Path srcFile = e.getPath();
            if (srcFS.isDirectory(srcFile)) {
                String msg = "Configuration dir " + srcDirPath + " contains a directory " + srcFile;
                log.warn(msg);
                throw new IOException(msg);
            }
            log.debug("copying src conf file {}", (Object)srcFile);
            sourcePaths[i] = srcFile;
            ++i;
        }
        log.debug("Copying {} files from {} to dest {}", new Object[]{srcFileCount, srcDirPath, destDirPath});
        FileUtil.copy((FileSystem)srcFS, (Path[])sourcePaths, (FileSystem)destFS, (Path)destDirPath, (boolean)false, (boolean)true, (Configuration)conf);
        return srcFileCount;
    }

    public static void copy(Configuration conf, Path srcFile, Path destFile) throws IOException, BadClusterStateException {
        FileSystem srcFS = FileSystem.get((URI)srcFile.toUri(), (Configuration)conf);
        if (!srcFS.exists(srcFile)) {
            throw new FileNotFoundException("Source file not found " + srcFile);
        }
        if (!srcFS.isFile(srcFile)) {
            throw new FileNotFoundException("Source file not a file " + srcFile);
        }
        FileSystem destFS = FileSystem.get((URI)destFile.toUri(), (Configuration)conf);
        if (destFS.exists(destFile)) {
            throw new IOException("Dest file already exists " + destFile);
        }
        FileUtil.copy((FileSystem)srcFS, (Path)srcFile, (FileSystem)destFS, (Path)destFile, (boolean)false, (boolean)true, (Configuration)conf);
    }

    public static String stringify(Throwable t) {
        StringWriter sw = new StringWriter();
        sw.append(t.toString()).append('\n');
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String extractFirstLine(String msg) {
        int newlineIndex;
        if (StringUtils.isNotBlank((String)msg) && (newlineIndex = msg.indexOf(System.lineSeparator())) != -1) {
            msg = msg.substring(0, newlineIndex);
        }
        return msg;
    }

    public static YarnConfiguration createConfiguration() {
        YarnConfiguration conf = new YarnConfiguration();
        SliderUtils.patchConfiguration((Configuration)conf);
        return conf;
    }

    public static Configuration patchConfiguration(Configuration conf) {
        if (conf.get("ipc.client.fallback-to-simple-auth-allowed") == null) {
            conf.set("ipc.client.fallback-to-simple-auth-allowed", "true");
        }
        return conf;
    }

    public static List<String> collectionToStringList(Collection c) {
        ArrayList<String> l = new ArrayList<String>(c.size());
        for (Object o : c) {
            l.add(o.toString());
        }
        return l;
    }

    public static String join(Collection collection, String separator) {
        return SliderUtils.join(collection, separator, true);
    }

    public static String join(Collection collection, String separator, boolean trailing) {
        StringBuilder b = new StringBuilder();
        if (collection.isEmpty()) {
            return trailing ? separator : "";
        }
        for (Object o : collection) {
            b.append(o);
            b.append(separator);
        }
        int length = separator.length();
        String s = b.toString();
        return trailing || s.isEmpty() ? s : b.substring(0, b.length() - length);
    }

    public static String join(String[] collection, String separator) {
        return SliderUtils.join(collection, separator, true);
    }

    public static String join(String[] collection, String separator, boolean trailing) {
        return SliderUtils.join(Arrays.asList(collection), separator, trailing);
    }

    public static String joinWithInnerSeparator(String separator, Object ... collection) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        Object[] objectArray = collection;
        int n = collection.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (first) {
                first = false;
            } else {
                b.append(separator);
            }
            b.append(o.toString());
            b.append(separator);
            ++n2;
        }
        return b.toString();
    }

    public static String mandatoryEnvVariable(String key) throws BadClusterStateException {
        String v = System.getenv(key);
        if (v == null) {
            throw new BadClusterStateException("Missing Environment variable " + key, new Object[0]);
        }
        return v;
    }

    public static String appReportToString(ApplicationReport r, String separator) {
        String diagnostics;
        String rpcHost;
        StringBuilder builder = new StringBuilder(512);
        builder.append("application ").append(r.getName()).append("/").append(r.getApplicationType()).append(separator);
        Set tags = r.getApplicationTags();
        if (!tags.isEmpty()) {
            for (String tag : tags) {
                builder.append(tag).append(separator);
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        dateFormat.setTimeZone(TimeZone.getDefault());
        builder.append("state: ").append(r.getYarnApplicationState());
        String trackingUrl = r.getTrackingUrl();
        if (SliderUtils.isSet(trackingUrl)) {
            builder.append(separator).append("URL: ").append(trackingUrl);
        }
        builder.append(separator).append("Started: ").append(dateFormat.format(new Date(r.getStartTime())));
        long finishTime = r.getFinishTime();
        if (finishTime > 0L) {
            builder.append(separator).append("Finished: ").append(dateFormat.format(new Date(finishTime)));
        }
        if (!SliderUtils.isSet(rpcHost = r.getHost())) {
            builder.append(separator).append("RPC :").append(rpcHost).append(':').append(r.getRpcPort());
        }
        if (!SliderUtils.isSet(diagnostics = r.getDiagnostics())) {
            builder.append(separator).append("Diagnostics :").append(diagnostics);
        }
        return builder.toString();
    }

    public static String instanceDetailsToString(String name, ApplicationReport report, List<ContainerInformation> containers, String version, Set<String> components, boolean verbose) {
        String staticf = "%-30s";
        String reportedf = String.valueOf(staticf) + "  %10s  %-42s";
        String livef = String.valueOf(reportedf) + "  %s";
        StringBuilder builder = new StringBuilder(200);
        if (report == null) {
            builder.append(String.format(staticf, name));
        } else {
            String appId = report.getApplicationId().toString();
            String state = report.getYarnApplicationState().toString();
            if (report.getYarnApplicationState() == YarnApplicationState.RUNNING) {
                builder.append(String.format(livef, name, state, appId, report.getTrackingUrl()));
            } else {
                builder.append(String.format(reportedf, name, state, appId));
            }
            if (verbose) {
                builder.append('\n');
                builder.append(SliderUtils.appReportToString(report, "\n  "));
            }
            if (containers != null) {
                builder.append('\n');
                builder.append(SliderUtils.containersToString(containers, version, components));
            }
        }
        builder.append('\n');
        return builder.toString();
    }

    public static String containersToString(List<ContainerInformation> containers, String version, Set<String> components) {
        String containerf = "  %-28s  %30s  %45s  %s\n";
        StringBuilder builder = new StringBuilder(512);
        builder.append("Containers:\n");
        builder.append(String.format("  %-28s  %30s  %45s  %s\n", "Component Name", "App Version", "Container Id", "Container Info/Logs"));
        for (ContainerInformation container : containers) {
            if (SliderUtils.filter(container.appVersion, version) || SliderUtils.filter(container.component, components)) continue;
            builder.append(String.format(containerf, container.component, container.appVersion, container.containerId, String.valueOf(container.host) + "/node/container/" + container.containerId));
        }
        return builder.toString();
    }

    public static boolean filter(String value, String filter) {
        return !StringUtils.isEmpty((String)filter) && !filter.equals(value);
    }

    public static boolean filter(String value, Set<String> filters) {
        return !filters.isEmpty() && !filters.contains(value);
    }

    public static void sortApplicationsByMostRecent(List<ApplicationReport> instances) {
        Collections.sort(instances, new MostRecentlyStartedOrFinishedFirst());
    }

    public static void sortApplicationReport(List<ApplicationReport> instances) {
        if (instances.size() <= 1) {
            return;
        }
        ArrayList<ApplicationReport> nonLiveInstance = new ArrayList<ApplicationReport>(instances.size());
        ArrayList<ApplicationReport> liveInstance = new ArrayList<ApplicationReport>(instances.size());
        for (ApplicationReport report : instances) {
            if (report.getYarnApplicationState() == YarnApplicationState.RUNNING || report.getYarnApplicationState() == YarnApplicationState.ACCEPTED) {
                liveInstance.add(report);
                continue;
            }
            nonLiveInstance.add(report);
        }
        if (liveInstance.size() > 1) {
            Collections.sort(liveInstance, new MostRecentlyStartedAppFirst());
        }
        if (nonLiveInstance.size() > 1) {
            Collections.sort(nonLiveInstance, new MostRecentAppFinishFirst());
        }
        instances.clear();
        instances.addAll(liveInstance);
        instances.addAll(nonLiveInstance);
    }

    public static Map<String, ApplicationReport> buildApplicationReportMap(List<ApplicationReport> instances, YarnApplicationState minState, YarnApplicationState maxState) {
        TreeMap<String, ApplicationReport> map = new TreeMap<String, ApplicationReport>();
        for (ApplicationReport report : instances) {
            YarnApplicationState state = report.getYarnApplicationState();
            if (state.ordinal() < minState.ordinal() || state.ordinal() > maxState.ordinal() || map.get(report.getName()) != null) continue;
            map.put(report.getName(), report);
        }
        return map;
    }

    public static Map<String, String> sortedMap(Map<String, String> source) {
        TreeMap<String, String> out = new TreeMap<String, String>(source);
        return out;
    }

    public static Map<String, String> toMap(Properties properties) {
        HashMap<String, String> out = new HashMap<String, String>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            out.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return out;
    }

    public static Map<String, String> mergeMap(Map<String, String> first, Map<String, String> second) {
        first.putAll(second);
        return first;
    }

    public static Map<String, String> mergeEntries(Map<String, String> dest, Iterable<Map.Entry<String, String>> entries) {
        for (Map.Entry<String, String> entry : entries) {
            dest.put(entry.getKey(), entry.getValue());
        }
        return dest;
    }

    public static <T1, T2> Map<T1, T2> mergeMaps(Map<T1, T2> first, Map<T1, T2> second) {
        first.putAll(second);
        return first;
    }

    public static <T1, T2> Map<T1, T2> mergeMapsIgnoreDuplicateKeys(Map<T1, T2> first, Map<T1, T2> second) {
        Preconditions.checkArgument((first != null ? 1 : 0) != 0, (Object)"Null 'first' value");
        Preconditions.checkArgument((second != null ? 1 : 0) != 0, (Object)"Null 'second' value");
        for (Map.Entry<T1, T2> entry : second.entrySet()) {
            T1 key = entry.getKey();
            if (first.containsKey(key)) continue;
            first.put(key, entry.getValue());
        }
        return first;
    }

    public static Map<String, String> mergeMapsIgnoreDuplicateKeysAndPrefixes(Map<String, String> first, Map<String, String> second, String ... prefixes) {
        Preconditions.checkArgument((first != null ? 1 : 0) != 0, (Object)"Null 'first' value");
        Preconditions.checkArgument((second != null ? 1 : 0) != 0, (Object)"Null 'second' value");
        Preconditions.checkArgument((prefixes != null ? 1 : 0) != 0, (Object)"Null 'prefixes' value");
        for (Map.Entry<String, String> entry : second.entrySet()) {
            String key = entry.getKey();
            boolean hasPrefix = false;
            String[] stringArray = prefixes;
            int n = prefixes.length;
            int n2 = 0;
            while (n2 < n) {
                String prefix = stringArray[n2];
                if (key.startsWith(prefix)) {
                    hasPrefix = true;
                    break;
                }
                ++n2;
            }
            if (hasPrefix || first.containsKey(key)) continue;
            first.put(key, entry.getValue());
        }
        return first;
    }

    public static String stringifyMap(Map<String, String> map) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"\n");
        }
        return builder.toString();
    }

    public static int getIntValue(Map<String, String> roleMap, String key, int defVal, int min, int max) throws BadConfigException {
        String valS = roleMap.get(key);
        return SliderUtils.parseAndValidate(key, valS, defVal, min, max);
    }

    public static int parseAndValidate(String errorKey, String valS, int defVal, int min, int max) throws BadConfigException {
        int val;
        if (valS == null) {
            valS = Integer.toString(defVal);
        }
        String trim = valS.trim();
        try {
            val = Integer.decode(trim);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadConfigException("Failed to parse value of " + errorKey + ": \"" + trim + "\"");
        }
        if (min >= 0 && val < min) {
            throw new BadConfigException("Value of " + errorKey + ": " + val + "is less than the minimum of " + min);
        }
        if (max >= 0 && val > max) {
            throw new BadConfigException("Value of " + errorKey + ": " + val + "is more than the maximum of " + max);
        }
        return val;
    }

    public static InetSocketAddress getRmAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    public static InetSocketAddress getRmSchedulerAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
    }

    public static boolean isRmSchedulerAddressDefined(Configuration conf) {
        InetSocketAddress address = SliderUtils.getRmSchedulerAddress(conf);
        return SliderUtils.isAddressDefined(address);
    }

    public static boolean isAddressDefined(InetSocketAddress address) {
        if (address == null || address.getHostString() == null) {
            return false;
        }
        return !address.getHostString().equals("0.0.0.0");
    }

    public static void setRmAddress(Configuration conf, String rmAddr) {
        conf.set("yarn.resourcemanager.address", rmAddr);
    }

    public static void setRmSchedulerAddress(Configuration conf, String rmAddr) {
        conf.set("yarn.resourcemanager.scheduler.address", rmAddr);
    }

    public static boolean hasAppFinished(ApplicationReport report) {
        return report == null || report.getYarnApplicationState().ordinal() >= YarnApplicationState.FINISHED.ordinal();
    }

    public static String containerToString(Container container) {
        if (container == null) {
            return "null container";
        }
        return String.format(Locale.ENGLISH, "ContainerID=%s nodeID=%s http=%s priority=%s resource=%s", container.getId(), container.getNodeId(), container.getNodeHttpAddress(), container.getPriority(), container.getResource());
    }

    public static String reportToString(ApplicationReport report) {
        if (report == null) {
            return "Null application report";
        }
        return "App " + report.getName() + "/" + report.getApplicationType() + "# " + report.getApplicationId() + " user " + report.getUser() + " is in state " + report.getYarnApplicationState() + " RPC: " + report.getHost() + ":" + report.getRpcPort() + " URL: " + report.getOriginalTrackingUrl();
    }

    public static String stringify(URL url) {
        StringBuilder builder = new StringBuilder();
        builder.append(url.getScheme()).append("://");
        if (url.getHost() != null) {
            builder.append(url.getHost()).append(":").append(url.getPort());
        }
        builder.append(url.getFile());
        return builder.toString();
    }

    public static int findFreePort(int start, int limit) {
        if (start == 0) {
            return 0;
        }
        int found = 0;
        int port = start;
        int finish = start + limit;
        while (found == 0 && port < finish) {
            if (SliderUtils.isPortAvailable(port)) {
                found = port;
                continue;
            }
            ++port;
        }
        return found;
    }

    public static int getOpenPort() throws IOException {
        try (ServerSocket socket = null;){
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
    }

    public static boolean isPortAvailable(int port) {
        try {
            ServerSocket socket = new ServerSocket(port);
            socket.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static Map<String, String> buildEnvMap(Map<String, String> roleOpts) {
        return SliderUtils.buildEnvMap(roleOpts, null);
    }

    public static Map<String, String> buildEnvMap(Map<String, String> roleOpts, Map<String, String> tokenMap) {
        HashMap<String, String> env = new HashMap<String, String>();
        if (roleOpts != null) {
            for (Map.Entry<String, String> entry : roleOpts.entrySet()) {
                String envName;
                String key = entry.getKey();
                if (!key.startsWith("env.") || (envName = key.substring("env.".length())).isEmpty()) continue;
                String value = entry.getValue();
                if (tokenMap != null) {
                    for (Map.Entry<String, String> token : tokenMap.entrySet()) {
                        value = value.replaceAll(Pattern.quote(token.getKey()), token.getValue());
                    }
                }
                env.put(envName, value);
            }
        }
        return env;
    }

    public static void applyCommandLineRoleOptsToRoleMap(Map<String, Map<String, String>> clusterRoleMap, Map<String, Map<String, String>> commandOptions) {
        for (Map.Entry<String, Map<String, String>> entry : commandOptions.entrySet()) {
            String key = entry.getKey();
            Map<String, String> optionMap = entry.getValue();
            Map<String, String> existingMap = clusterRoleMap.get(key);
            if (existingMap == null) {
                existingMap = new HashMap<String, String>();
            }
            log.debug("Overwriting role options with command line values {}", (Object)SliderUtils.stringifyMap(optionMap));
            SliderUtils.mergeMap(existingMap, optionMap);
            clusterRoleMap.put(key, existingMap);
        }
    }

    public static void validateClusterName(String clustername) throws BadCommandArgumentsException {
        if (!SliderUtils.isClusternameValid(clustername)) {
            throw new BadCommandArgumentsException("Illegal cluster name: " + clustername, new Object[0]);
        }
    }

    public static void verifyPrincipalSet(Configuration conf, String principal) throws BadConfigException {
        String principalName = conf.get(principal);
        if (principalName == null) {
            throw new BadConfigException("Unset Kerberos principal : %s", principal);
        }
        log.debug("Kerberos princial {}={}", (Object)principal, (Object)principalName);
    }

    public static boolean isHadoopClusterSecure(Configuration conf) {
        return SecurityUtil.getAuthenticationMethod((Configuration)conf) != UserGroupInformation.AuthenticationMethod.SIMPLE;
    }

    public static boolean maybeInitSecurity(Configuration conf) throws IOException, SliderException {
        boolean clusterSecure = SliderUtils.isHadoopClusterSecure(conf);
        if (clusterSecure) {
            log.debug("Enabling security");
            SliderUtils.initProcessSecurity(conf);
        }
        return clusterSecure;
    }

    public static boolean initProcessSecurity(Configuration conf) throws IOException, SliderException {
        if (processSecurityAlreadyInitialized.compareAndSet(true, true)) {
            return false;
        }
        log.info("JVM initialized into secure mode with kerberos realm {}", (Object)SliderUtils.getKerberosRealm());
        log.debug("java.security.krb5.realm={}", (Object)System.getProperty(JAVA_SECURITY_KRB5_REALM, ""));
        log.debug("java.security.krb5.kdc={}", (Object)System.getProperty(JAVA_SECURITY_KRB5_KDC, ""));
        log.debug("hadoop.security.authentication={}", (Object)conf.get("hadoop.security.authentication"));
        log.debug("hadoop.security.authorization={}", (Object)conf.get("hadoop.security.authorization"));
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation authUser = UserGroupInformation.getCurrentUser();
        log.debug("Authenticating as {}", (Object)authUser);
        log.debug("Login user is {}", (Object)UserGroupInformation.getLoginUser());
        if (!UserGroupInformation.isSecurityEnabled()) {
            throw new SliderException(41, "Although secure mode is enabled,the application has already set up its user as an insecure entity %s", authUser);
        }
        if (authUser.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.SIMPLE) {
            throw new BadConfigException("Auth User is not Kerberized %s -security has already been set up with the wrong authentication method. This can occur if a file system has already been created prior to the loading of the security configuration.", authUser);
        }
        SliderUtils.verifyPrincipalSet(conf, "yarn.resourcemanager.principal");
        SliderUtils.verifyPrincipalSet(conf, "dfs.namenode.kerberos.principal");
        return true;
    }

    public static void forceLogin() throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            if (UserGroupInformation.isLoginKeytabBased()) {
                UserGroupInformation.getLoginUser().reloginFromKeytab();
            } else {
                UserGroupInformation.getLoginUser().reloginFromTicketCache();
            }
        }
    }

    public static LocalResource putJar(Map<String, LocalResource> providerResources, SliderFileSystem sliderFileSystem, Class clazz, Path tempPath, String libdir, String jarName) throws IOException, SliderException {
        LocalResource res = sliderFileSystem.submitJarWithClass(clazz, tempPath, libdir, jarName);
        providerResources.put(String.valueOf(libdir) + "/" + jarName, res);
        return res;
    }

    public static void putAllJars(Map<String, LocalResource> providerResources, SliderFileSystem sliderFileSystem, Path tempPath, String libDir, String srcPath) throws IOException, SliderException {
        log.info("Loading all dependencies from {}", (Object)srcPath);
        if (SliderUtils.isSet(srcPath)) {
            File srcFolder = new File(srcPath);
            FilenameFilter jarFilter = SliderUtils.createJarFilter();
            File[] listOfJars = srcFolder.listFiles(jarFilter);
            if (listOfJars == null || listOfJars.length == 0) {
                return;
            }
            File[] fileArray = listOfJars;
            int n = listOfJars.length;
            int n2 = 0;
            while (n2 < n) {
                File jarFile = fileArray[n2];
                LocalResource res = sliderFileSystem.submitFile(jarFile, tempPath, libDir, jarFile.getName());
                providerResources.put(String.valueOf(libDir) + "/" + jarFile.getName(), res);
                ++n2;
            }
        }
    }

    public static FilenameFilter createJarFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase(Locale.ENGLISH).endsWith(".jar");
            }
        };
    }

    public static void putAmTarGzipAndUpdate(Map<String, LocalResource> providerResources, SliderFileSystem sliderFileSystem) throws IOException, SliderException {
        sliderFileSystem.submitTarGzipAndUpdate(providerResources);
    }

    public static Map<String, Map<String, String>> deepClone(Map<String, Map<String, String>> src) {
        HashMap<String, Map<String, String>> dest = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : src.entrySet()) {
            dest.put(entry.getKey(), SliderUtils.stringMapClone(entry.getValue()));
        }
        return dest;
    }

    public static Map<String, String> stringMapClone(Map<String, String> src) {
        HashMap<String, String> dest = new HashMap<String, String>();
        return SliderUtils.mergeEntries(dest, src.entrySet());
    }

    public static String listDir(File dir) {
        if (dir == null) {
            return "";
        }
        String[] confDirEntries = dir.list();
        if (confDirEntries == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String[] stringArray = confDirEntries;
        int n = confDirEntries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            builder.append(entry).append("\n");
            ++n2;
        }
        return builder.toString();
    }

    public static Path createLocalPath(File file) {
        return new Path(file.toURI());
    }

    public static UserGroupInformation getCurrentUser() throws IOException {
        try {
            UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
            return currentUser;
        }
        catch (IOException e) {
            log.info("Failed to get user info", (Throwable)e);
            throw e;
        }
    }

    public static String getKerberosRealm() {
        try {
            return KerberosUtil.getDefaultRealm();
        }
        catch (Exception e) {
            log.debug("introspection into JVM internals failed", (Throwable)e);
            return "(unknown)";
        }
    }

    public static java.net.URL registerClientResource() {
        return ConfigHelper.registerDefaultResource("slider-client.xml");
    }

    public static Configuration loadSliderClientXML() {
        return ConfigHelper.loadFromResource("slider-client.xml");
    }

    public static String sequenceToString(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder(charSequence);
        return stringBuilder.toString();
    }

    public static ClasspathConstructor buildClasspath(String sliderConfDir, String libdir, Configuration config, SliderFileSystem sliderFileSystem, boolean usingMiniMRCluster) {
        ClasspathConstructor classpath = new ClasspathConstructor();
        if (usingMiniMRCluster) {
            classpath.appendAll(classpath.localJVMClasspath());
        } else {
            if (sliderConfDir != null) {
                classpath.addClassDirectory(sliderConfDir);
            }
            classpath.addLibDir(libdir);
            if (sliderFileSystem.isFile(sliderFileSystem.getDependencyTarGzip())) {
                classpath.addLibDir("slider_dep");
            } else {
                log.info("For faster submission of apps, upload dependencies using cmd {} {}", (Object)"dependency", (Object)"--upload");
            }
            classpath.addRemoteClasspathEnvVar();
            classpath.append(ApplicationConstants.Environment.HADOOP_CONF_DIR.$$());
        }
        return classpath;
    }

    public static void verifyIsDir(File dir, Logger errorlog) throws FileNotFoundException {
        if (!dir.exists()) {
            errorlog.warn("contents of {}: {}", (Object)dir, (Object)SliderUtils.listDir(dir.getParentFile()));
            throw new FileNotFoundException(dir.toString());
        }
        if (!dir.isDirectory()) {
            errorlog.info("contents of {}: {}", (Object)dir, (Object)SliderUtils.listDir(dir.getParentFile()));
            throw new FileNotFoundException("Not a directory: " + dir);
        }
    }

    public static void verifyFileExists(File file, Logger errorlog) throws FileNotFoundException {
        if (!file.exists()) {
            errorlog.warn("contents of {}: {}", (Object)file, (Object)SliderUtils.listDir(file.getParentFile()));
            throw new FileNotFoundException(file.toString());
        }
        if (!file.isFile()) {
            throw new FileNotFoundException("Not a file: " + file.toString());
        }
    }

    public static String verifyOptionSet(Configuration configuration, String key, boolean allowEmpty) throws BadConfigException {
        String val = configuration.get(key);
        if (val == null) {
            throw new BadConfigException("Required configuration option \"%s\" not defined ", key);
        }
        if (!allowEmpty && val.isEmpty()) {
            throw new BadConfigException("Configuration option \"%s\" must not be empty", key);
        }
        return val;
    }

    public static File verifyKeytabExists(Configuration siteConf, String prop) throws BadConfigException {
        String keytab = siteConf.get(prop);
        if (keytab == null) {
            throw new BadConfigException("Missing keytab property %s", prop);
        }
        File keytabFile = new File(keytab);
        if (!keytabFile.exists()) {
            throw new BadConfigException("Missing keytab file %s defined in %s", keytabFile, prop);
        }
        if (keytabFile.length() == 0L || !keytabFile.isFile()) {
            throw new BadConfigException("Invalid keytab file %s defined in %s", keytabFile, prop);
        }
        return keytabFile;
    }

    public static String toGMTString(long time) {
        return new Date(time).toGMTString();
    }

    public static void addBuildInfo(Map<String, String> info, String prefix) {
        Properties props = SliderVersionInfo.loadVersionProperties();
        info.put(String.valueOf(prefix) + "." + "application.build.info", props.getProperty("application.build.info"));
        info.put(String.valueOf(prefix) + "." + "hadoop.build.info", props.getProperty("hadoop.build.info"));
        info.put(String.valueOf(prefix) + "." + "hadoop.deployed.info", String.valueOf(VersionInfo.getBranch()) + " @" + VersionInfo.getSrcChecksum());
    }

    public static void setInfoTime(Map info, String keyHumanTime, String keyMachineTime, long time) {
        info.put(keyHumanTime, SliderUtils.toGMTString(time));
        info.put(keyMachineTime, Long.toString(time));
    }

    public static Path extractImagePath(CoreFileSystem fs, MapOperations internalOptions) throws SliderException, IOException {
        Path imagePath;
        String imagePathOption = internalOptions.get("internal.application.image.path");
        String appHomeOption = internalOptions.get("internal.application.home");
        if (!SliderUtils.isUnset(imagePathOption)) {
            if (!SliderUtils.isUnset(appHomeOption)) {
                throw new BadClusterStateException("Both application image path and home dir have been provided", new Object[0]);
            }
            imagePath = fs.createPathThatMustExist(imagePathOption);
        } else {
            imagePath = null;
            if (SliderUtils.isUnset(appHomeOption)) {
                throw new BadClusterStateException("Neither an image path nor binary home directory were specified", new Object[0]);
            }
        }
        return imagePath;
    }

    public static Timer haltAM(int status, String text, int delay) {
        Timer timer = new Timer("halt timer", false);
        timer.schedule((TimerTask)new DelayedHalt(status, text), delay);
        return timer;
    }

    public static String propertiesToString(Properties props) {
        TreeSet<String> keys = new TreeSet<String>(props.stringPropertyNames());
        StringBuilder builder = new StringBuilder();
        for (String key : keys) {
            builder.append(key).append("=").append(props.getProperty(key)).append("\n");
        }
        return builder.toString();
    }

    public static String appendToURL(String base, String path) {
        StringBuilder fullpath = new StringBuilder(base);
        if (!base.endsWith("/")) {
            fullpath.append("/");
        }
        if (path.startsWith("/")) {
            fullpath.append(path.substring(1));
        } else {
            fullpath.append(path);
        }
        return fullpath.toString();
    }

    public static String appendToURL(String base, String ... paths) {
        String result = base;
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            result = SliderUtils.appendToURL(result, path);
            ++n2;
        }
        return result;
    }

    public static String truncate(String toTruncate, int maxSize) {
        if (toTruncate == null || maxSize < 1 || toTruncate.length() <= maxSize) {
            return toTruncate;
        }
        String pad = "...";
        if (maxSize < 10) {
            pad = "";
        }
        return toTruncate.substring(0, maxSize - pad.length()).concat(pad);
    }

    public static String extractNodeLabel(NodeReport report) {
        Set newlabels = report.getNodeLabels();
        if (newlabels != null && !newlabels.isEmpty()) {
            return ((String)newlabels.iterator().next()).trim();
        }
        return "";
    }

    public static int compareTo(long left, long right) {
        long diff = left - right;
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 0;
    }

    public static void zipFolder(File srcFolder, File zipFile) throws IOException {
        log.info("Zipping folder {} to {}", (Object)srcFolder.getAbsolutePath(), (Object)zipFile.getAbsolutePath());
        ArrayList<String> files = new ArrayList<String>();
        SliderUtils.generateFileList(files, srcFolder, srcFolder, true);
        byte[] buffer = new byte[1024];
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream fos = new FileOutputStream(zipFile);){
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (ZipOutputStream zos = new ZipOutputStream(fos);){
                for (String file : files) {
                    ZipEntry ze = new ZipEntry(file);
                    zos.putNextEntry(ze);
                    Throwable throwable3 = null;
                    Object var14_19 = null;
                    try (FileInputStream in = new FileInputStream(srcFolder + File.separator + file);){
                        int len;
                        while ((len = in.read(buffer)) > 0) {
                            zos.write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    public static void tarGzipFolder(File srcFolder, File tarGzipFile, FilenameFilter filter) throws IOException {
        log.info("Tar-gzipping folder {} to {}", (Object)srcFolder.getAbsolutePath(), (Object)tarGzipFile.getAbsolutePath());
        ArrayList<String> files = new ArrayList<String>();
        SliderUtils.generateFileList(files, srcFolder, srcFolder, true, filter);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TarArchiveOutputStream taos = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(tarGzipFile))));){
            for (String file : files) {
                File srcFile = new File(srcFolder, file);
                TarArchiveEntry tarEntry = new TarArchiveEntry(srcFile, file);
                taos.putArchiveEntry((ArchiveEntry)tarEntry);
                Throwable throwable2 = null;
                Object var12_15 = null;
                try (FileInputStream in = new FileInputStream(srcFile);){
                    IOUtils.copy((InputStream)in, (OutputStream)taos);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                taos.flush();
                taos.closeArchiveEntry();
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static String getHdpVersion() {
        String hdpVersion = System.getProperty("HDP_VERSION");
        if (StringUtils.isEmpty((String)hdpVersion)) {
            hdpVersion = System.getenv("HDP_VERSION");
        }
        return hdpVersion;
    }

    public static boolean isHdp() {
        return StringUtils.isNotEmpty((String)SliderUtils.getHdpVersion());
    }

    public static String getSliderVersion() {
        if (SliderUtils.isHdp()) {
            return SliderUtils.getHdpVersion();
        }
        Properties props = SliderVersionInfo.loadVersionProperties();
        return props.getProperty("application.version");
    }

    private static void generateFileList(List<String> fileList, File node, File rootFolder, Boolean relative) {
        SliderUtils.generateFileList(fileList, node, rootFolder, relative, null);
    }

    private static void generateFileList(List<String> fileList, File node, File rootFolder, Boolean relative, FilenameFilter filter) {
        if (node.isFile()) {
            String fileFullPath = node.toString();
            if (relative.booleanValue()) {
                fileList.add(fileFullPath.substring(rootFolder.toString().length() + 1, fileFullPath.length()));
            } else {
                fileList.add(fileFullPath);
            }
        }
        if (node.isDirectory()) {
            String[] subNode = node.list(filter);
            if (subNode == null || subNode.length == 0) {
                return;
            }
            String[] stringArray = subNode;
            int n = subNode.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                SliderUtils.generateFileList(fileList, new File(node, filename), rootFolder, relative, filter);
                ++n2;
            }
        }
    }

    public static InputStream getApplicationResourceInputStream(FileSystem fs, Path appPath, String entry) throws IOException {
        ByteArrayInputStream is = null;
        Throwable throwable = null;
        Object var5_6 = null;
        try (FSDataInputStream appStream = fs.open(appPath);){
            ZipArchiveEntry zipEntry;
            ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)appStream);
            boolean done = false;
            while (!done && (zipEntry = zis.getNextZipEntry()) != null) {
                if (!entry.equals(zipEntry.getName())) continue;
                int size = (int)zipEntry.getSize();
                if (size != -1) {
                    log.info("Reading {} of size {}", (Object)zipEntry.getName(), (Object)zipEntry.getSize());
                    byte[] content = new byte[size];
                    int offset = 0;
                    while (offset < size) {
                        offset += zis.read(content, offset, size - offset);
                    }
                    is = new ByteArrayInputStream(content);
                } else {
                    int byteRead;
                    log.debug("Size unknown. Reading {}", (Object)zipEntry.getName());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while ((byteRead = zis.read()) != -1) {
                        baos.write(byteRead);
                    }
                    is = new ByteArrayInputStream(baos.toByteArray());
                }
                done = true;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return is;
    }

    public static String checkForRequiredNativeLibraries() {
        if (!Shell.WINDOWS) {
            return "";
        }
        StringBuilder errorText = new StringBuilder("");
        if (!NativeIO.isAvailable()) {
            errorText.append("No native IO library. ");
        }
        try {
            String path = Shell.getQualifiedBinPath((String)WINUTILS);
            log.debug("winutils is at {}", (Object)path);
        }
        catch (IOException e) {
            errorText.append("No WINUTILS.EXE");
            log.warn("No winutils: {}", (Object)e, (Object)e);
        }
        try {
            File target = new File("target");
            FileUtil.canRead((File)target);
        }
        catch (UnsatisfiedLinkError e) {
            log.warn("Failing to link to native IO methods: {}", (Object)e, (Object)e);
            errorText.append("No native IO methods");
        }
        return errorText.toString();
    }

    public static void maybeVerifyWinUtilsValid() throws IOException, SliderException {
        String errorText = SliderUtils.checkForRequiredNativeLibraries();
        if (!errorText.isEmpty()) {
            throw new BadClusterStateException(errorText, new Object[0]);
        }
    }

    public static void verifyIsFile(String program, File exe) throws FileNotFoundException {
        if (!exe.isFile()) {
            throw new FileNotFoundException(String.valueOf(program) + " at " + exe + " is not a file");
        }
    }

    public static void verifyFileSize(String program, File exe, int minFileSize) throws FileNotFoundException {
        if (exe.length() < (long)minFileSize) {
            throw new FileNotFoundException(String.valueOf(program) + " at " + exe + " is too short to be an executable");
        }
    }

    public static void verifyWindowsExe(String program, File exe) throws IOException {
        SliderUtils.verifyIsFile(program, exe);
        SliderUtils.verifyFileSize(program, exe, 256);
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileReader reader = new FileReader(exe);){
            int[] header = new int[]{reader.read(), reader.read()};
            if (header[0] != 77 || header[1] != 90) {
                throw new FileNotFoundException(String.valueOf(program) + " at " + exe + " is not a windows executable file");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void verifyUnixExe(String program, File exe) throws IOException {
        SliderUtils.verifyIsFile(program, exe);
        if (!exe.canRead()) {
            throw new IOException("Cannot read " + program + " at " + exe);
        }
        if (!exe.canExecute()) {
            throw new IOException("Cannot execute " + program + " at " + exe);
        }
    }

    public static void validateExe(String program, File exe) throws IOException {
        if (!Shell.WINDOWS) {
            SliderUtils.verifyWindowsExe(program, exe);
        } else {
            SliderUtils.verifyUnixExe(program, exe);
        }
    }

    public static void write(File outfile, byte[] data, boolean createParent) throws IOException {
        File parentDir = outfile.getCanonicalFile().getParentFile();
        if (parentDir == null) {
            throw new IOException(String.valueOf(outfile.getPath()) + " has no parent dir");
        }
        if (createParent) {
            parentDir.mkdirs();
        }
        SliderUtils.verifyIsDir(parentDir, log);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream out = new FileOutputStream(outfile);){
            out.write(data);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static ForkedProcessService execCommand(String name, int status, long timeoutMillis, Logger logger, String outputString, String ... commands) throws IOException, SliderException {
        Preconditions.checkArgument((boolean)SliderUtils.isSet(name), (Object)"no name");
        Preconditions.checkArgument((commands.length > 0 ? 1 : 0) != 0, (Object)"no commands");
        Preconditions.checkArgument((boolean)SliderUtils.isSet(commands[0]), (Object)"empty command");
        ForkedProcessService process = new ForkedProcessService(name, new HashMap<String, String>(), Arrays.asList(commands));
        process.setProcessLog(logger);
        process.init(new Configuration());
        String errorText = null;
        process.start();
        try {
            if (!process.waitForServiceToStop(timeoutMillis)) {
                throw new TimeoutException("Process did not stop in " + timeoutMillis + "mS");
            }
            int exitCode = process.getExitCode();
            List<String> recentOutput = process.getRecentOutput();
            if (status != exitCode) {
                errorText = "Expected exit code={" + status + "}, " + "actual exit code={" + exitCode + "}";
            } else if (SliderUtils.isSet(outputString)) {
                boolean found = false;
                for (String line : recentOutput) {
                    if (!line.contains(outputString)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    errorText = "Did not find \"" + outputString + "\"" + " in output";
                }
            }
            if (errorText == null) {
                return process;
            }
        }
        catch (TimeoutException e) {
            errorText = e.toString();
        }
        log.warn(errorText);
        List<String> recentOutput = process.getRecentOutput();
        for (String line : recentOutput) {
            log.info(line);
        }
        throw new SliderException(5, "Process %s failed: %s", name, errorText);
    }

    public static void validateSliderClientEnvironment(Logger logger) throws IOException, SliderException {
        SliderUtils.maybeVerifyWinUtilsValid();
    }

    public static void validateSliderServerEnvironment(Logger logger, boolean dependencyChecks) throws IOException, SliderException {
        SliderUtils.maybeVerifyWinUtilsValid();
        if (dependencyChecks) {
            SliderUtils.validatePythonEnv(logger);
            SliderUtils.validateOpenSSLEnv(logger);
        }
    }

    public static void validateOpenSSLEnv(Logger logger) throws IOException, SliderException {
        SliderUtils.execCommand(OPENSSL, 0, 5000L, logger, "OpenSSL", OPENSSL, "version");
    }

    public static void validatePythonEnv(Logger logger) throws IOException, SliderException {
        SliderUtils.execCommand(PYTHON, 0, 5000L, logger, "Python", PYTHON, "-V");
    }

    public static String getCurrentCommandPath() {
        File f = new File(Slider.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        return f.getAbsolutePath();
    }

    public static String getApplicationDefinitionPath(ConfTreeOperations conf) throws BadConfigException {
        return SliderUtils.getApplicationDefinitionPath(conf, null);
    }

    public static String getApplicationDefinitionPath(ConfTreeOperations conf, String roleGroup) throws BadConfigException {
        MapOperations component;
        String appDefPath = conf.getGlobalOptions().getMandatoryOption("application.def");
        if (roleGroup != null && (component = conf.getComponent(roleGroup)) != null) {
            appDefPath = component.getOption("application.def", appDefPath);
        }
        return appDefPath;
    }

    public static String getClientConfigPath() {
        java.net.URL path = ConfigHelper.class.getClassLoader().getResource("slider-client.xml");
        Preconditions.checkNotNull((Object)path, (Object)"Failed to locate resource slider-client.xml");
        return path.toString();
    }

    public static void validateClientConfigFile() throws IOException {
        java.net.URL resURL = SliderVersionInfo.class.getClassLoader().getResource("slider-client.xml");
        if (resURL == null) {
            throw new IOException("slider-client.xml doesn't exist on the path: " + SliderUtils.getClientConfigPath());
        }
        try {
            InputStream inStream = resURL.openStream();
            if (inStream == null) {
                throw new IOException("slider-client.xml can't be opened");
            }
        }
        catch (IOException e) {
            throw new IOException("slider-client.xml can't be opened: " + e.toString());
        }
    }

    public static void validateHDFSFile(SliderFileSystem sliderFileSystem, String pathStr) throws IOException, URISyntaxException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FSDataInputStream inputStream = sliderFileSystem.getFileSystem().open(new Path(new URI(pathStr)));){
            if (inputStream == null) {
                throw new IOException("HDFS file " + pathStr + " can't be opened");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getJDKInfo() {
        String version = System.getProperty("java.version");
        String javaHome = System.getProperty("java.home");
        return "The version of the JDK invoking the current running slider command: " + version + "; The path to it is: " + javaHome;
    }

    public static String checkCredentialCacheFile() throws IOException, BadConfigException {
        String result = null;
        if (!Shell.WINDOWS) {
            result = Shell.execCommand((String[])new String[]{"klist"});
        }
        return result;
    }

    public static int compareTwoLongsReverse(long x, long y) {
        return x < y ? 1 : (x == y ? 0 : -1);
    }

    public static String getSystemEnv(String property) {
        return System.getenv(property);
    }

    public static Map<String, String> getSystemEnv() {
        return System.getenv();
    }

    public static String requestToString(AMRMClient.ContainerRequest request) {
        List racks;
        List nodes;
        Preconditions.checkArgument((request != null ? 1 : 0) != 0, (Object)"Null request");
        StringBuilder buffer = new StringBuilder(request.toString());
        buffer.append("; ");
        buffer.append("relaxLocality=").append(request.getRelaxLocality()).append("; ");
        String labels = request.getNodeLabelExpression();
        if (labels != null) {
            buffer.append("nodeLabels=").append(labels).append("; ");
        }
        if ((nodes = request.getNodes()) != null) {
            buffer.append("Nodes = [ ");
            int size = nodes.size();
            int i = 0;
            while (i < Math.min(10, size)) {
                buffer.append((String)nodes.get(i)).append(' ');
                ++i;
            }
            if (size > 10) {
                buffer.append(String.format("...(total %d entries)", size));
            }
            buffer.append("]; ");
        }
        if ((racks = request.getRacks()) != null) {
            buffer.append("racks = [").append(SliderUtils.join(racks, ", ", false)).append("]; ");
        }
        return buffer.toString();
    }

    public static String trimPrefix(String prefix) {
        if (prefix != null && prefix.endsWith("-")) {
            return prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    public static class DelayedHalt
    extends TimerTask {
        private final int status;
        private final String text;

        public DelayedHalt(int status, String text) {
            this.status = status;
            this.text = text;
        }

        @Override
        public void run() {
            try {
                ExitUtil.halt((int)this.status, (String)this.text);
            }
            catch (ExitUtil.HaltException haltException) {
                log.info("Halt failed");
            }
        }
    }

    private static class MostRecentAppFinishFirst
    implements Comparator<ApplicationReport>,
    Serializable {
        private MostRecentAppFinishFirst() {
        }

        @Override
        public int compare(ApplicationReport r1, ApplicationReport r2) {
            long x = r1.getFinishTime();
            long y = r2.getFinishTime();
            return SliderUtils.compareTwoLongsReverse(x, y);
        }
    }

    private static class MostRecentlyStartedAppFirst
    implements Comparator<ApplicationReport>,
    Serializable {
        private MostRecentlyStartedAppFirst() {
        }

        @Override
        public int compare(ApplicationReport r1, ApplicationReport r2) {
            long x = r1.getStartTime();
            long y = r2.getStartTime();
            return SliderUtils.compareTwoLongsReverse(x, y);
        }
    }

    private static class MostRecentlyStartedOrFinishedFirst
    implements Comparator<ApplicationReport>,
    Serializable {
        private MostRecentlyStartedOrFinishedFirst() {
        }

        @Override
        public int compare(ApplicationReport r1, ApplicationReport r2) {
            long started1 = r1.getStartTime();
            long started2 = r2.getStartTime();
            long finished1 = r1.getFinishTime();
            long finished2 = r2.getFinishTime();
            long lastEvent1 = Math.max(started1, finished1);
            long lastEvent2 = Math.max(started2, finished2);
            return SliderUtils.compareTwoLongsReverse(lastEvent1, lastEvent2);
        }
    }

    public static class OnDemandReportStringifier {
        private final ApplicationReport report;

        public OnDemandReportStringifier(ApplicationReport report) {
            this.report = report;
        }

        public String toString() {
            return SliderUtils.appReportToString(this.report, "\n");
        }
    }
}

