/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.agent.application.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.providers.agent.application.metadata.AbstractMetainfoSchema;
import org.apache.slider.providers.agent.application.metadata.CommandOrder;
import org.apache.slider.providers.agent.application.metadata.Component;
import org.apache.slider.providers.agent.application.metadata.ConfigFile;
import org.apache.slider.providers.agent.application.metadata.ExportGroup;
import org.apache.slider.providers.agent.application.metadata.Metainfo;
import org.apache.slider.providers.agent.application.metadata.OSSpecific;
import org.apache.slider.providers.agent.application.metadata.Package;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class Application
extends AbstractMetainfoSchema {
    String exportedConfigs;
    List<ExportGroup> exportGroups = new ArrayList<ExportGroup>();
    List<OSSpecific> osSpecifics = new ArrayList<OSSpecific>();
    List<CommandOrder> commandOrders = new ArrayList<CommandOrder>();
    List<Package> packages = new ArrayList<Package>();
    private List<Component> components = new ArrayList<Component>();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    public String getExportedConfigs() {
        return this.exportedConfigs;
    }

    public void setExportedConfigs(String exportedConfigs) {
        this.exportedConfigs = exportedConfigs;
    }

    @Override
    public void addConfigFile(ConfigFile configFile) {
        this.configFiles.add(configFile);
    }

    @Override
    @JsonProperty(value="configFiles")
    public List<ConfigFile> getConfigFiles() {
        return this.configFiles;
    }

    public void addComponent(Component component) {
        this.components.add(component);
    }

    @JsonProperty(value="components")
    public List<Component> getComponents() {
        return this.components;
    }

    public void addExportGroup(ExportGroup exportGroup) {
        this.exportGroups.add(exportGroup);
    }

    @JsonProperty(value="exportGroups")
    public List<ExportGroup> getExportGroups() {
        return this.exportGroups;
    }

    public void addOSSpecific(OSSpecific osSpecific) {
        this.osSpecifics.add(osSpecific);
    }

    @JsonIgnore
    public List<OSSpecific> getOSSpecifics() {
        return this.osSpecifics;
    }

    public void addCommandOrder(CommandOrder commandOrder) {
        this.commandOrders.add(commandOrder);
    }

    @JsonProperty(value="commandOrders")
    public List<CommandOrder> getCommandOrders() {
        return this.commandOrders;
    }

    public void addPackage(Package pkg) {
        this.packages.add(pkg);
    }

    @JsonProperty(value="packages")
    public List<Package> getPackages() {
        return this.packages;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append(",\n\"name\": ").append(this.name);
        sb.append(",\n\"comment\": ").append(this.comment);
        sb.append(",\n\"version\" :").append(this.version);
        sb.append(",\n\"components\" : {");
        for (Component component : this.components) {
            sb.append("\n").append(component.toString());
        }
        sb.append("\n},");
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void validate(String version) throws SliderException {
        if (SliderUtils.isUnset(version)) {
            throw new BadCommandArgumentsException("schema version cannot be null", new Object[0]);
        }
        Metainfo.checkNonNull(this.getName(), "name", "application");
        Metainfo.checkNonNull(this.getVersion(), "version", "application");
        if (this.getComponents().size() == 0) {
            throw new SliderException("application must contain at least one component");
        }
        if (version.equals(Metainfo.VERSION_TWO_ZERO) && this.getPackages().size() > 0) {
            throw new SliderException("packages is not supported in version " + version);
        }
        if (version.equals(Metainfo.VERSION_TWO_ONE) && this.getOSSpecifics().size() > 0) {
            throw new SliderException("osSpecifics is not supported in version " + version);
        }
        for (CommandOrder co : this.getCommandOrders()) {
            co.validate(version);
        }
        for (Component comp : this.getComponents()) {
            comp.validate(version);
        }
        for (ConfigFile cf : this.getConfigFiles()) {
            cf.validate(version);
        }
        for (ExportGroup eg : this.getExportGroups()) {
            eg.validate(version);
        }
        for (Package pkg : this.getPackages()) {
            pkg.validate(version);
        }
        for (OSSpecific os : this.getOSSpecifics()) {
            os.validate(version);
        }
    }
}

