/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.rpc;

import com.google.common.base.Preconditions;
import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtocolProxy;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcEngine;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.slider.api.SliderClusterProtocol;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.server.appmaster.rpc.SliderClusterProtocolPB;
import org.apache.slider.server.appmaster.rpc.SliderClusterProtocolProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcBinder {
    protected static final Logger log = LoggerFactory.getLogger(RpcBinder.class);

    public static Server createProtobufServer(InetSocketAddress addr, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, int numHandlers, BlockingService blockingService, String portRangeConfig) throws IOException {
        Class<SliderClusterProtocolPB> sliderClusterAPIClass = RpcBinder.registerSliderAPI(conf);
        RPC.Server server = new RPC.Builder(conf).setProtocol(sliderClusterAPIClass).setInstance((Object)blockingService).setBindAddress(addr.getAddress().getCanonicalHostName()).setPort(addr.getPort()).setNumHandlers(numHandlers).setVerbose(false).setSecretManager(secretManager).setPortRangeConfig(portRangeConfig).build();
        log.debug("Adding protocol " + sliderClusterAPIClass.getCanonicalName() + " to the server");
        server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, sliderClusterAPIClass, (Object)blockingService);
        return server;
    }

    public static Class<SliderClusterProtocolPB> registerSliderAPI(Configuration conf) {
        Class<SliderClusterProtocolPB> sliderClusterAPIClass = SliderClusterProtocolPB.class;
        RPC.setProtocolEngine((Configuration)conf, sliderClusterAPIClass, ProtobufRpcEngine.class);
        assert (RpcBinder.verifyBondedToProtobuf(conf, sliderClusterAPIClass));
        return sliderClusterAPIClass;
    }

    public static boolean verifyBondedToProtobuf(Configuration conf, Class<SliderClusterProtocolPB> sliderClusterAPIClass) {
        return conf.getClass("rpc.engine." + sliderClusterAPIClass.getName(), RpcEngine.class).equals(ProtobufRpcEngine.class);
    }

    public static SliderClusterProtocol connectToServer(InetSocketAddress addr, UserGroupInformation currentUser, Configuration conf, int rpcTimeout) throws IOException {
        Class<SliderClusterProtocolPB> sliderClusterAPIClass = RpcBinder.registerSliderAPI(conf);
        RetryPolicy retryPolicy = RetryPolicies.TRY_ONCE_THEN_FAIL;
        log.debug("Connecting to Slider AM at {}", (Object)addr);
        ProtocolProxy protoProxy = RPC.getProtocolProxy(sliderClusterAPIClass, (long)1L, (InetSocketAddress)addr, (UserGroupInformation)currentUser, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)rpcTimeout, (RetryPolicy)retryPolicy);
        SliderClusterProtocolPB endpoint = (SliderClusterProtocolPB)protoProxy.getProxy();
        return new SliderClusterProtocolProxy(endpoint, addr);
    }

    /*
     * Exception decompiling
     */
    public static SliderClusterProtocol getProxy(Configuration conf, ApplicationClientProtocol rmClient, ApplicationReport application, int connectTimeout, int rpcTimeout) throws IOException, YarnException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static SliderClusterProtocol getProxy(Configuration conf, ApplicationReport application, int rpcTimeout) throws IOException, SliderException, InterruptedException {
        String host = application.getHost();
        int port = application.getRpcPort();
        org.apache.hadoop.yarn.api.records.Token clientToAMToken = application.getClientToAMToken();
        return RpcBinder.createProxy(conf, host, port, clientToAMToken, rpcTimeout);
    }

    public static SliderClusterProtocol createProxy(final Configuration conf, String host, int port, org.apache.hadoop.yarn.api.records.Token clientToAMToken, final int rpcTimeout) throws SliderException, IOException, InterruptedException {
        SliderClusterProtocol realProxy;
        String address = String.valueOf(host) + ":" + port;
        if (SliderUtils.isUnset(host) || port == 0) {
            throw new SliderException(48, "Slider instance  isn't providing a valid address for the Slider RPC protocol: " + address);
        }
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        final UserGroupInformation newUgi = UserGroupInformation.createRemoteUser((String)currentUser.getUserName());
        final InetSocketAddress serviceAddr = NetUtils.createSocketAddrForHost((String)host, (int)port);
        log.debug("Connecting to {}", (Object)serviceAddr);
        if (UserGroupInformation.isSecurityEnabled()) {
            Preconditions.checkArgument((clientToAMToken != null ? 1 : 0) != 0, (Object)"Null clientToAMToken");
            Token token = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)clientToAMToken, (InetSocketAddress)serviceAddr);
            newUgi.addToken(token);
            realProxy = (SliderClusterProtocol)newUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<SliderClusterProtocol>(){

                @Override
                public SliderClusterProtocol run() throws IOException {
                    return RpcBinder.connectToServer(serviceAddr, newUgi, conf, rpcTimeout);
                }
            });
        } else {
            realProxy = RpcBinder.connectToServer(serviceAddr, newUgi, conf, rpcTimeout);
        }
        return realProxy;
    }
}

