/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.rest.application;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.slider.api.types.ApplicationDiagnostics;
import org.apache.slider.api.types.ApplicationLivenessInformation;
import org.apache.slider.api.types.ComponentInformation;
import org.apache.slider.api.types.ContainerInformation;
import org.apache.slider.api.types.NodeInformation;
import org.apache.slider.api.types.NodeInformationList;
import org.apache.slider.api.types.PingInformation;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTree;
import org.apache.slider.core.exceptions.NoSuchNodeException;
import org.apache.slider.core.persist.ConfTreeSerDeser;
import org.apache.slider.server.appmaster.actions.ActionFlexCluster;
import org.apache.slider.server.appmaster.actions.AsyncAction;
import org.apache.slider.server.appmaster.actions.QueueAccess;
import org.apache.slider.server.appmaster.state.RoleInstance;
import org.apache.slider.server.appmaster.state.StateAccessForProviders;
import org.apache.slider.server.appmaster.web.WebAppApi;
import org.apache.slider.server.appmaster.web.rest.AbstractSliderResource;
import org.apache.slider.server.appmaster.web.rest.application.actions.RestActionPing;
import org.apache.slider.server.appmaster.web.rest.application.actions.RestActionStop;
import org.apache.slider.server.appmaster.web.rest.application.actions.StopResponse;
import org.apache.slider.server.appmaster.web.rest.application.resources.ContentCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApplicationResource
extends AbstractSliderResource {
    private static final Logger log = LoggerFactory.getLogger(ApplicationResource.class);
    public static final List<String> LIVE_ENTRIES = ApplicationResource.toJsonList("resources", "containers", "components", "nodes", "statistics", "internal");
    public static final List<String> ROOT_ENTRIES = ApplicationResource.toJsonList("model", "live", "actions");
    public static final List<String> MODEL_ENTRIES = ApplicationResource.toJsonList("desired", "resolved");
    private final ContentCache cache;
    private final StateAccessForProviders state;
    private final QueueAccess actionQueues;

    public ApplicationResource(WebAppApi slider) {
        super(slider);
        this.state = slider.getAppState();
        this.cache = slider.getContentCache();
        this.actionQueues = slider.getQueues();
    }

    private static List<String> toJsonList(String ... elements) {
        return Lists.newArrayList((Object[])elements);
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public List<String> getRoot() {
        this.markGet("/application");
        return ROOT_ENTRIES;
    }

    @GET
    @Path(value="/model")
    @Produces(value={"application/json"})
    public List<String> getModel() {
        this.markGet("/application", "/model");
        return MODEL_ENTRIES;
    }

    @GET
    @Path(value="/model/desired")
    @Produces(value={"application/json"})
    public AggregateConf getModelDesired() {
        this.markGet("/application", "/model/desired");
        return this.lookupAggregateConf("/model/desired");
    }

    @GET
    @Path(value="/model/desired/appconf")
    @Produces(value={"application/json"})
    public ConfTree getModelDesiredAppconf() {
        this.markGet("/application", "/model/desired/appconf");
        return this.lookupConfTree("/model/desired/appconf");
    }

    @GET
    @Path(value="/model/desired/resources")
    @Produces(value={"application/json"})
    public ConfTree getModelDesiredResources() {
        this.markGet("/application", "/model/desired/resources");
        return this.lookupConfTree("/model/desired/resources");
    }

    public ConfTree setModelDesiredResources(String json) {
        this.markPut("/application", "/model/desired/resources");
        int size = json != null ? json.length() : 0;
        log.info("PUT {} {} bytes:\n{}", new Object[]{"/model/desired/resources", size, json});
        if (size == 0) {
            log.warn("No JSON in PUT request; rejecting");
            throw new BadRequestException("No JSON in PUT");
        }
        try {
            ConfTreeSerDeser serDeser = new ConfTreeSerDeser();
            ConfTree updated = (ConfTree)serDeser.fromJson(json);
            this.queue(new ActionFlexCluster("flex", 1L, TimeUnit.MILLISECONDS, updated));
            return updated;
        }
        catch (Exception e) {
            throw this.buildException("PUT to /model/desired/resources", e);
        }
    }

    @PUT
    @Path(value="/model/desired/resources")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ConfTree setModelDesiredResources(ConfTree updated) {
        try {
            this.queue(new ActionFlexCluster("flex", 1L, TimeUnit.MILLISECONDS, updated));
            return updated;
        }
        catch (Exception e) {
            throw this.buildException("PUT to /model/desired/resources", e);
        }
    }

    @GET
    @Path(value="/model/resolved")
    @Produces(value={"application/json"})
    public AggregateConf getModelResolved() {
        this.markGet("/application", "/model/resolved");
        return this.lookupAggregateConf("/model/resolved");
    }

    @GET
    @Path(value="/model/resolved/appconf")
    @Produces(value={"application/json"})
    public ConfTree getModelResolvedAppconf() {
        this.markGet("/application", "/model/resolved/appconf");
        return this.lookupConfTree("/model/resolved/appconf");
    }

    @GET
    @Path(value="/model/resolved/resources")
    @Produces(value={"application/json"})
    public ConfTree getModelResolvedResources() {
        this.markGet("/application", "/model/resolved/resources");
        return this.lookupConfTree("/model/resolved/resources");
    }

    @GET
    @Path(value="/live")
    @Produces(value={"application/json"})
    public List<String> getLive() {
        this.markGet("/application", "/live");
        return LIVE_ENTRIES;
    }

    @GET
    @Path(value="/live/resources")
    @Produces(value={"application/json"})
    public ConfTree getLiveResources() {
        this.markGet("/application", "/live/resources");
        return this.lookupConfTree("/live/resources");
    }

    @GET
    @Path(value="/live/containers")
    @Produces(value={"application/json"})
    public Map<String, ContainerInformation> getLiveContainers() {
        this.markGet("/application", "/live/containers");
        try {
            return (Map)this.cache.lookup("/live/containers");
        }
        catch (Exception e) {
            throw this.buildException("/live/containers", e);
        }
    }

    @GET
    @Path(value="/live/containers/{containerId}")
    @Produces(value={"application/json"})
    public ContainerInformation getLiveContainer(@PathParam(value="containerId") String containerId) {
        this.markGet("/application", "/live/containers");
        try {
            RoleInstance id = this.state.getLiveInstanceByContainerID(containerId);
            return id.serialize();
        }
        catch (NoSuchNodeException noSuchNodeException) {
            throw new NotFoundException("Unknown container: " + containerId);
        }
        catch (Exception e) {
            throw this.buildException("/live/containers/" + containerId, e);
        }
    }

    @GET
    @Path(value="/live/components")
    @Produces(value={"application/json"})
    public Map<String, ComponentInformation> getLiveComponents() {
        this.markGet("/application", "/live/components");
        try {
            return (Map)this.cache.lookup("/live/components");
        }
        catch (Exception e) {
            throw this.buildException("/live/components", e);
        }
    }

    @GET
    @Path(value="/live/components/{component}")
    @Produces(value={"application/json"})
    public ComponentInformation getLiveComponent(@PathParam(value="component") String component) {
        this.markGet("/application", "/live/components");
        try {
            return this.state.getComponentInformation(component);
        }
        catch (YarnRuntimeException yarnRuntimeException) {
            throw new NotFoundException("Unknown component: " + component);
        }
        catch (Exception e) {
            throw this.buildException("/live/containers/" + component, e);
        }
    }

    @GET
    @Path(value="/live/liveness")
    @Produces(value={"application/json"})
    public ApplicationLivenessInformation getLivenessInformation() {
        this.markGet("/application", "/live/liveness");
        try {
            return this.state.getApplicationLivenessInformation();
        }
        catch (Exception e) {
            throw this.buildException("/live/containers", e);
        }
    }

    @GET
    @Path(value="/live/diagnostics")
    @Produces(value={"application/json"})
    public ApplicationDiagnostics getApplicationDiagnostics() {
        this.markGet("/application", "/live/diagnostics");
        try {
            return this.state.getApplicationDiagnostics();
        }
        catch (Exception e) {
            throw this.buildException("/live/containers", e);
        }
    }

    @GET
    @Path(value="/live/nodes")
    @Produces(value={"application/json"})
    public NodeInformationList getLiveNodes() {
        this.markGet("/application", "/live/nodes");
        try {
            return (NodeInformationList)this.cache.lookup("/live/nodes");
        }
        catch (Exception e) {
            throw this.buildException("/live/components", e);
        }
    }

    @GET
    @Path(value="/live/nodes/{hostname}")
    @Produces(value={"application/json"})
    public NodeInformation getLiveNode(@PathParam(value="hostname") String hostname) {
        this.markGet("/application", "/live/nodes");
        try {
            NodeInformation ni = this.state.getNodeInformation(hostname);
            if (ni != null) {
                return ni;
            }
            throw new NotFoundException("Unknown node: " + hostname);
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.buildException("/live/components/" + hostname, e);
        }
    }

    @GET
    @Path(value="/live/statistics")
    @Produces(value={"application/json"})
    public Map<String, Integer> getLiveStatistics() {
        this.markGet("/application", "/live/statistics");
        try {
            return (Map)this.cache.lookup("/live/statistics");
        }
        catch (Exception e) {
            throw this.buildException("/live/statistics", e);
        }
    }

    protected AggregateConf lookupAggregateConf(String key) {
        try {
            return (AggregateConf)this.cache.lookup(key);
        }
        catch (Exception e) {
            throw this.buildException(key, e);
        }
    }

    protected ConfTree lookupConfTree(String key) {
        try {
            return (ConfTree)this.cache.lookup(key);
        }
        catch (Exception e) {
            throw this.buildException(key, e);
        }
    }

    @GET
    @Path(value="/action/ping")
    @Produces(value={"application/json"})
    public PingInformation actionPingGet(@Context HttpServletRequest request, @Context UriInfo uriInfo) {
        this.markGet("/application", "/action/ping");
        return new RestActionPing().ping(request, uriInfo, "");
    }

    @POST
    @Path(value="/action/ping")
    @Produces(value={"application/json"})
    public PingInformation actionPingPost(@Context HttpServletRequest request, @Context UriInfo uriInfo, String body) {
        this.markPost("/application", "/action/ping");
        return new RestActionPing().ping(request, uriInfo, body);
    }

    @PUT
    @Path(value="/action/ping")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public PingInformation actionPingPut(@Context HttpServletRequest request, @Context UriInfo uriInfo, String body) {
        this.markPut("/application", "/action/ping");
        return new RestActionPing().ping(request, uriInfo, body);
    }

    @DELETE
    @Path(value="/action/ping")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public PingInformation actionPingDelete(@Context HttpServletRequest request, @Context UriInfo uriInfo) {
        this.markDelete("/application", "/action/ping");
        return new RestActionPing().ping(request, uriInfo, "");
    }

    @HEAD
    @Path(value="/action/ping")
    public Object actionPingHead(@Context HttpServletRequest request, @Context UriInfo uriInfo) {
        this.mark("HEAD", "/application", "/action/ping");
        return new RestActionPing().ping(request, uriInfo, "");
    }

    @POST
    @Path(value="/action/stop")
    @Produces(value={"application/json"})
    public StopResponse actionStop(@Context HttpServletRequest request, @Context UriInfo uriInfo, String body) {
        this.markPost("/application", "/action/stop");
        return new RestActionStop(this.slider).stop(request, uriInfo, body);
    }

    public void schedule(AsyncAction action) {
        this.actionQueues.schedule(action);
    }

    public void queue(AsyncAction action) {
        this.actionQueues.put(action);
    }
}

