/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.avro;

import com.google.common.annotations.VisibleForTesting;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.GlobFilter;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.server.appmaster.state.NodeEntry;
import org.apache.slider.server.appmaster.state.NodeInstance;
import org.apache.slider.server.appmaster.state.RoleHistory;
import org.apache.slider.server.avro.LoadedRoleHistory;
import org.apache.slider.server.avro.NewerFilesFirst;
import org.apache.slider.server.avro.NodeEntryRecord;
import org.apache.slider.server.avro.OlderFilesFirst;
import org.apache.slider.server.avro.RoleHistoryFooter;
import org.apache.slider.server.avro.RoleHistoryHeader;
import org.apache.slider.server.avro.RoleHistoryMapping;
import org.apache.slider.server.avro.RoleHistoryRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleHistoryWriter {
    protected static final Logger log = LoggerFactory.getLogger(RoleHistoryWriter.class);
    public static final int ROLE_HISTORY_VERSION = 1;

    public long write(OutputStream out, RoleHistory history, long savetime) throws IOException {
        try {
            SpecificDatumWriter writer = new SpecificDatumWriter(RoleHistoryRecord.class);
            RoleHistoryRecord record = this.createHeaderRecord(savetime, history);
            int roles = history.getRoleSize();
            Schema schema = record.getSchema();
            JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, out);
            writer.write((Object)record, (Encoder)encoder);
            writer.write((Object)this.createRolemapRecord(history), (Encoder)encoder);
            long count = 0L;
            Collection instances = history.cloneNodemap().values();
            for (NodeInstance instance : instances) {
                int role = 0;
                while (role < roles) {
                    NodeEntry nodeEntry = instance.get(role);
                    if (nodeEntry != null) {
                        NodeEntryRecord ner = this.build(nodeEntry, role, instance.hostname);
                        record = new RoleHistoryRecord((Object)ner);
                        writer.write((Object)record, (Encoder)encoder);
                        ++count;
                    }
                    ++role;
                }
            }
            RoleHistoryFooter footer = new RoleHistoryFooter();
            footer.setCount(count);
            writer.write((Object)new RoleHistoryRecord((Object)footer), (Encoder)encoder);
            encoder.flush();
            long l = count;
            return l;
        }
        finally {
            out.close();
        }
    }

    private RoleHistoryRecord createHeaderRecord(long savetime, RoleHistory history) {
        RoleHistoryHeader header = new RoleHistoryHeader();
        header.setVersion(1);
        header.setSaved(savetime);
        header.setSavedx(Long.toHexString(savetime));
        header.setSavedate(SliderUtils.toGMTString(savetime));
        header.setRoles(history.getRoleSize());
        return new RoleHistoryRecord((Object)header);
    }

    private RoleHistoryRecord createRolemapRecord(RoleHistory history) {
        RoleHistoryMapping entry = new RoleHistoryMapping();
        Map<CharSequence, Integer> mapping = history.buildMappingForHistoryFile();
        entry.setRolemap(mapping);
        return new RoleHistoryRecord((Object)entry);
    }

    public long write(FileSystem fs, Path path, boolean overwrite, RoleHistory history, long savetime) throws IOException {
        FSDataOutputStream out = fs.create(path, overwrite);
        return this.write((OutputStream)out, history, savetime);
    }

    public Path createHistoryFilename(Path historyPath, long time) {
        String filename = String.format(Locale.ENGLISH, "rolehistory-%016x.json", time);
        Path path = new Path(historyPath, filename);
        return path;
    }

    private NodeEntryRecord build(NodeEntry entry, int role, String hostname) {
        NodeEntryRecord record = new NodeEntryRecord(hostname, role, entry.getLive() > 0, entry.getLastUsed());
        return record;
    }

    public LoadedRoleHistory read(InputStream in) throws IOException, BadConfigException {
        try {
            LoadedRoleHistory loadedRoleHistory = new LoadedRoleHistory();
            SpecificDatumReader reader = new SpecificDatumReader(RoleHistoryRecord.class);
            JsonDecoder decoder = DecoderFactory.get().jsonDecoder(RoleHistoryRecord.getClassSchema(), in);
            RoleHistoryRecord record = (RoleHistoryRecord)((Object)reader.read(null, (Decoder)decoder));
            if (record == null) {
                throw new IOException("Role History Header not found at start of file.");
            }
            Object entry = record.getEntry();
            if (!(entry instanceof RoleHistoryHeader)) {
                throw new IOException("Role History Header not found at start of file");
            }
            RoleHistoryHeader header = (RoleHistoryHeader)((Object)entry);
            if (header.getVersion() != 1) {
                throw new IOException(String.format("Can't read role file version %04x -need %04x", header.getVersion(), 1));
            }
            loadedRoleHistory.setHeader(header);
            RoleHistoryFooter footer = null;
            int records = 0;
            try {
                while (footer == null) {
                    record = (RoleHistoryRecord)((Object)reader.read(null, (Decoder)decoder));
                    if (record == null) {
                        throw new IOException("Null record after " + records + " records");
                    }
                    entry = record.getEntry();
                    if (entry instanceof RoleHistoryHeader) {
                        throw new IOException("Duplicate Role History Header found");
                    }
                    if (entry instanceof RoleHistoryMapping) {
                        if (!loadedRoleHistory.roleMap.isEmpty()) {
                            log.warn("Duplicate role map; ignoring");
                            continue;
                        }
                        RoleHistoryMapping historyMapping = (RoleHistoryMapping)((Object)entry);
                        loadedRoleHistory.buildMapping(historyMapping.getRolemap());
                        continue;
                    }
                    if (entry instanceof NodeEntryRecord) {
                        ++records;
                        NodeEntryRecord nodeEntryRecord = (NodeEntryRecord)((Object)entry);
                        loadedRoleHistory.add(nodeEntryRecord);
                        continue;
                    }
                    if (entry instanceof RoleHistoryFooter) {
                        footer = (RoleHistoryFooter)((Object)entry);
                        continue;
                    }
                    log.warn("Discarding unknown record {}", entry);
                }
            }
            catch (EOFException e) {
                EOFException ex = new EOFException("End of file reached after " + records + " records");
                ex.initCause(e);
                throw ex;
            }
            if (in.read() > 0) {
                throw new EOFException("File footer reached before end of file -after " + records + " records");
            }
            if ((long)records != footer.getCount()) {
                log.warn("mismatch between no of records saved {} and number read {}", (Object)footer.getCount(), (Object)records);
            }
            LoadedRoleHistory loadedRoleHistory2 = loadedRoleHistory;
            return loadedRoleHistory2;
        }
        finally {
            in.close();
        }
    }

    public LoadedRoleHistory read(FileSystem fs, Path path) throws IOException, BadConfigException {
        FSDataInputStream instream = fs.open(path);
        return this.read((InputStream)instream);
    }

    public LoadedRoleHistory read(String resource) throws IOException, BadConfigException {
        return this.read(this.getClass().getClassLoader().getResourceAsStream(resource));
    }

    public List<Path> findAllHistoryEntries(FileSystem fs, Path dir, boolean includeEmptyFiles) throws IOException {
        assert (fs != null);
        assert (dir != null);
        if (!fs.exists(dir)) {
            fs.mkdirs(dir);
        } else if (!fs.isDirectory(dir)) {
            throw new FileNotFoundException("Not a directory " + dir.toString());
        }
        GlobFilter filter = new GlobFilter("rolehistory-*.json");
        FileStatus[] stats = fs.listStatus(dir, (PathFilter)filter);
        ArrayList<Path> paths = new ArrayList<Path>(stats.length);
        FileStatus[] fileStatusArray = stats;
        int n = stats.length;
        int n2 = 0;
        while (n2 < n) {
            FileStatus stat = fileStatusArray[n2];
            log.debug("Possible entry: {}", (Object)stat.toString());
            if (stat.isFile() && (includeEmptyFiles || stat.getLen() > 0L)) {
                paths.add(stat.getPath());
            }
            ++n2;
        }
        RoleHistoryWriter.sortHistoryPaths(paths);
        return paths;
    }

    @VisibleForTesting
    public static void sortHistoryPaths(List<Path> paths) {
        Collections.sort(paths, new NewerFilesFirst());
    }

    public LoadedRoleHistory attemptToReadHistory(FileSystem fileSystem, List<Path> paths) throws BadConfigException {
        ListIterator<Path> pathIterator = paths.listIterator();
        boolean success = false;
        LoadedRoleHistory history = null;
        while (!success && pathIterator.hasNext()) {
            Path path = pathIterator.next();
            try {
                history = this.read(fileSystem, path);
                success = true;
                history.setPath(path);
            }
            catch (IOException e) {
                log.info("Failed to read {}", (Object)path, (Object)e);
            }
            catch (AvroTypeException e) {
                log.warn("Failed to parse {}", (Object)path, (Object)e);
            }
            catch (Exception e) {
                log.warn("Exception while reading {}", (Object)path, (Object)e);
            }
        }
        return history;
    }

    public LoadedRoleHistory loadFromHistoryDir(FileSystem fs, Path dir) throws IOException, BadConfigException {
        assert (fs != null) : "null filesystem";
        List<Path> entries = this.findAllHistoryEntries(fs, dir, false);
        return this.attemptToReadHistory(fs, entries);
    }

    public int purgeOlderHistoryEntries(FileSystem fileSystem, Path keep) throws IOException {
        assert (fileSystem != null) : "null filesystem";
        if (!fileSystem.exists(keep)) {
            throw new FileNotFoundException(keep.toString());
        }
        Path dir = keep.getParent();
        log.debug("Purging entries in {} up to {}", (Object)dir, (Object)keep);
        List<Path> paths = this.findAllHistoryEntries(fileSystem, dir, true);
        Collections.sort(paths, new OlderFilesFirst());
        int deleteCount = 0;
        for (Path path : paths) {
            if (path.equals((Object)keep)) break;
            log.debug("Deleting {}", (Object)path);
            ++deleteCount;
            fileSystem.delete(path, false);
        }
        return deleteCount;
    }
}

