/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.yarnregistry;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.slider.common.tools.SliderUtils;

public class YarnRegistryViewForProviders {
    private final RegistryOperations registryOperations;
    private final String user;
    private final String sliderServiceClass;
    private final String instanceName;
    private final ApplicationAttemptId applicationAttemptId;
    private ServiceRecord selfRegistration;
    private String selfRegistrationPath;

    public YarnRegistryViewForProviders(RegistryOperations registryOperations, String user, String sliderServiceClass, String instanceName, ApplicationAttemptId applicationAttemptId) {
        Preconditions.checkArgument((registryOperations != null ? 1 : 0) != 0, (Object)"null registry operations");
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"null user");
        Preconditions.checkArgument((boolean)SliderUtils.isSet(sliderServiceClass), (Object)"unset service class");
        Preconditions.checkArgument((boolean)SliderUtils.isSet(instanceName), (Object)"instanceName");
        Preconditions.checkArgument((applicationAttemptId != null ? 1 : 0) != 0, (Object)"null applicationAttemptId");
        this.registryOperations = registryOperations;
        this.user = user;
        this.sliderServiceClass = sliderServiceClass;
        this.instanceName = instanceName;
        this.applicationAttemptId = applicationAttemptId;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    public String getUser() {
        return this.user;
    }

    public String getSliderServiceClass() {
        return this.sliderServiceClass;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public RegistryOperations getRegistryOperations() {
        return this.registryOperations;
    }

    public ServiceRecord getSelfRegistration() {
        return this.selfRegistration;
    }

    private void setSelfRegistration(ServiceRecord selfRegistration) {
        this.selfRegistration = selfRegistration;
    }

    public String getSelfRegistrationPath() {
        return this.selfRegistrationPath;
    }

    public String getAbsoluteSelfRegistrationPath() {
        if (this.selfRegistrationPath == null) {
            return null;
        }
        String root = this.registryOperations.getConfig().getTrimmed("hadoop.registry.zk.root", "/registry");
        return RegistryPathUtils.join((String)root, (String)this.selfRegistrationPath);
    }

    public void putComponent(String componentName, ServiceRecord record) throws IOException {
        this.putComponent(this.sliderServiceClass, this.instanceName, componentName, record);
    }

    public void putComponent(String serviceClass, String serviceName, String componentName, ServiceRecord record) throws IOException {
        String path = RegistryUtils.componentPath((String)this.user, (String)serviceClass, (String)serviceName, (String)componentName);
        this.registryOperations.mknode(RegistryPathUtils.parentOf((String)path), true);
        this.registryOperations.bind(path, record, 1);
    }

    public String putService(String username, String serviceClass, String serviceName, ServiceRecord record, boolean deleteTreeFirst) throws IOException {
        String path = RegistryUtils.servicePath((String)username, (String)serviceClass, (String)serviceName);
        if (deleteTreeFirst) {
            this.registryOperations.delete(path, true);
        }
        this.registryOperations.mknode(RegistryPathUtils.parentOf((String)path), true);
        this.registryOperations.bind(path, record, 1);
        return path;
    }

    public String putService(String serviceClass, String serviceName, ServiceRecord record, boolean deleteTreeFirst) throws IOException {
        return this.putService(this.user, serviceClass, serviceName, record, deleteTreeFirst);
    }

    public String registerSelf(ServiceRecord record, boolean deleteTreeFirst) throws IOException {
        this.selfRegistrationPath = this.putService(this.user, this.sliderServiceClass, this.instanceName, record, deleteTreeFirst);
        this.setSelfRegistration(record);
        return this.selfRegistrationPath;
    }

    public void updateSelf() throws IOException {
        this.putService(this.user, this.sliderServiceClass, this.instanceName, this.selfRegistration, false);
    }

    public void deleteComponent(String componentName) throws IOException {
        String path = RegistryUtils.componentPath((String)this.user, (String)this.sliderServiceClass, (String)this.instanceName, (String)componentName);
        this.registryOperations.delete(path, false);
    }

    public void deleteChildren(String path, boolean recursive) throws IOException {
        List childNames = null;
        try {
            childNames = this.registryOperations.list(path);
        }
        catch (PathNotFoundException pathNotFoundException) {
            return;
        }
        for (String childName : childNames) {
            String child = RegistryPathUtils.join((String)path, (String)childName);
            this.registryOperations.delete(child, recursive);
        }
    }
}

